/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.http;

import java.io.IOException;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public enum C2RequestCompression {
    NONE("none"){

        @Override
        public Request compress(Request request) {
            return request;
        }
    }
    ,
    GZIP("gzip"){

        @Override
        public Request compress(Request request) {
            return request.newBuilder().header(C2RequestCompression.CONTENT_ENCODING_HEADER, C2RequestCompression.GZIP_ENCODING).method(request.method(), this.toGzipRequestBody(request.body())).build();
        }

        private RequestBody toGzipRequestBody(final RequestBody requestBody) {
            return new RequestBody(this){

                public MediaType contentType() {
                    return requestBody.contentType();
                }

                public long contentLength() {
                    return -1L;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    try (BufferedSink bufferedGzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));){
                        requestBody.writeTo(bufferedGzipSink);
                    }
                }
            };
        }
    };

    static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    static final String GZIP_ENCODING = "gzip";
    private final String compressionType;

    private C2RequestCompression(String compressionType) {
        this.compressionType = compressionType;
    }

    public static C2RequestCompression forType(String compressionType) {
        return Stream.of(C2RequestCompression.values()).filter(c2RequestCompression -> c2RequestCompression.compressionType.equalsIgnoreCase(compressionType)).findAny().orElse(NONE);
    }

    public abstract Request compress(Request var1);
}

