/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class C2ClientConfig {
    private final String c2Url;
    private final String c2AckUrl;
    private final String c2RestPathBase;
    private final String c2RestPathHeartbeat;
    private final String c2RestPathAcknowledge;
    private final String agentClass;
    private final String agentIdentifier;
    private final boolean fullHeartbeat;
    private final String confDirectory;
    private final String runtimeManifestIdentifier;
    private final String runtimeType;
    private final long heartbeatPeriod;
    private final String keystoreFilename;
    private final String keystorePass;
    private final String keyPass;
    private final String keystoreType;
    private final String truststoreFilename;
    private final String truststorePass;
    private final String truststoreType;
    private final long callTimeout;
    private final long readTimeout;
    private final Map<String, String> httpHeaders;
    private final long connectTimeout;
    private final int maxIdleConnections;
    private final long keepAliveDuration;
    private final String c2RequestCompression;
    private final String c2AssetDirectory;
    private final String c2AssetRepositoryDirectory;
    private final long bootstrapAcknowledgeTimeout;
    private final int c2FlowInfoProcessorBulletinLimit;
    private final boolean c2FlowInfoProcessorStatusEnabled;

    private C2ClientConfig(Builder builder) {
        this.c2Url = builder.c2Url;
        this.c2AckUrl = builder.c2AckUrl;
        this.c2RestPathBase = builder.c2RestPathBase;
        this.c2RestPathHeartbeat = builder.c2RestPathHeartbeat;
        this.c2RestPathAcknowledge = builder.c2RestPathAcknowledge;
        this.agentClass = builder.agentClass;
        this.agentIdentifier = builder.agentIdentifier;
        this.fullHeartbeat = builder.fullHeartbeat;
        this.confDirectory = builder.confDirectory;
        this.runtimeManifestIdentifier = builder.runtimeManifestIdentifier;
        this.runtimeType = builder.runtimeType;
        this.heartbeatPeriod = builder.heartbeatPeriod;
        this.callTimeout = builder.callTimeout;
        this.keystoreFilename = builder.keystoreFilename;
        this.keystorePass = builder.keystorePass;
        this.keyPass = builder.keyPass;
        this.keystoreType = builder.keystoreType;
        this.truststoreFilename = builder.truststoreFilename;
        this.truststorePass = builder.truststorePass;
        this.truststoreType = builder.truststoreType;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.httpHeaders = builder.httpHeaders;
        this.maxIdleConnections = builder.maxIdleConnections;
        this.keepAliveDuration = builder.keepAliveDuration;
        this.c2RequestCompression = builder.c2RequestCompression;
        this.c2AssetDirectory = builder.c2AssetDirectory;
        this.c2AssetRepositoryDirectory = builder.c2AssetRepositoryDirectory;
        this.bootstrapAcknowledgeTimeout = builder.bootstrapAcknowledgeTimeout;
        this.c2FlowInfoProcessorBulletinLimit = builder.c2FlowInfoProcessorBulletinLimit;
        this.c2FlowInfoProcessorStatusEnabled = builder.c2FlowInfoProcessorStatusEnabled;
    }

    public String getC2Url() {
        return this.c2Url;
    }

    public String getC2AckUrl() {
        return this.c2AckUrl;
    }

    public String getAgentClass() {
        return this.agentClass;
    }

    public String getAgentIdentifier() {
        return this.agentIdentifier;
    }

    public String getC2RestPathBase() {
        return this.c2RestPathBase;
    }

    public String getC2RestPathHeartbeat() {
        return this.c2RestPathHeartbeat;
    }

    public String getC2RestPathAcknowledge() {
        return this.c2RestPathAcknowledge;
    }

    public boolean isFullHeartbeat() {
        return this.fullHeartbeat;
    }

    public String getConfDirectory() {
        return this.confDirectory;
    }

    public String getRuntimeManifestIdentifier() {
        return this.runtimeManifestIdentifier;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public long getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public String getKeystoreFilename() {
        return this.keystoreFilename;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststoreFilename() {
        return this.truststoreFilename;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getC2RequestCompression() {
        return this.c2RequestCompression;
    }

    public String getC2AssetDirectory() {
        return this.c2AssetDirectory;
    }

    public String getC2AssetRepositoryDirectory() {
        return this.c2AssetRepositoryDirectory;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public long getBootstrapAcknowledgeTimeout() {
        return this.bootstrapAcknowledgeTimeout;
    }

    public int getC2FlowInfoProcessorBulletinLimit() {
        return this.c2FlowInfoProcessorBulletinLimit;
    }

    public boolean isC2FlowInfoProcessorStatusEnabled() {
        return this.c2FlowInfoProcessorStatusEnabled;
    }

    public static class Builder {
        private static final String HTTP_HEADERS_SEPARATOR = "#";
        private static final String HTTP_HEADER_KEY_VALUE_SEPARATOR = ":";
        private String c2Url;
        private String c2AckUrl;
        private String c2RestPathBase;
        private String c2RestPathHeartbeat;
        private String c2RestPathAcknowledge;
        private String agentClass;
        private String agentIdentifier;
        private boolean fullHeartbeat;
        private String confDirectory;
        private String runtimeManifestIdentifier;
        private String runtimeType;
        private long heartbeatPeriod;
        private long callTimeout;
        private String keystoreFilename;
        private String keystorePass;
        private String keyPass;
        private String keystoreType;
        private String truststoreFilename;
        private String truststorePass;
        private String truststoreType;
        private long readTimeout;
        private long connectTimeout;
        private Map<String, String> httpHeaders;
        private int maxIdleConnections;
        private long keepAliveDuration;
        private String c2RequestCompression;
        private String c2AssetDirectory;
        private String c2AssetRepositoryDirectory;
        private long bootstrapAcknowledgeTimeout;
        private int c2FlowInfoProcessorBulletinLimit;
        private boolean c2FlowInfoProcessorStatusEnabled;

        public Builder c2Url(String c2Url) {
            this.c2Url = c2Url;
            return this;
        }

        public Builder c2AckUrl(String c2AckUrl) {
            this.c2AckUrl = c2AckUrl;
            return this;
        }

        public Builder c2RestPathBase(String c2RestPathBase) {
            this.c2RestPathBase = c2RestPathBase;
            return this;
        }

        public Builder c2RestPathHeartbeat(String c2RestPathHeartbeat) {
            this.c2RestPathHeartbeat = c2RestPathHeartbeat;
            return this;
        }

        public Builder c2RestPathAcknowledge(String c2RestPathAcknowledge) {
            this.c2RestPathAcknowledge = c2RestPathAcknowledge;
            return this;
        }

        public Builder agentClass(String agentClass) {
            this.agentClass = agentClass;
            return this;
        }

        public Builder agentIdentifier(String agentIdentifier) {
            this.agentIdentifier = agentIdentifier;
            return this;
        }

        public Builder fullHeartbeat(boolean fullHeartbeat) {
            this.fullHeartbeat = fullHeartbeat;
            return this;
        }

        public Builder confDirectory(String confDirectory) {
            this.confDirectory = confDirectory;
            return this;
        }

        public Builder runtimeManifestIdentifier(String runtimeManifestIdentifier) {
            this.runtimeManifestIdentifier = runtimeManifestIdentifier;
            return this;
        }

        public Builder runtimeType(String runtimeType) {
            this.runtimeType = runtimeType;
            return this;
        }

        public Builder heartbeatPeriod(long heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public Builder callTimeout(long callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder keystoreFilename(String keystoreFilename) {
            this.keystoreFilename = keystoreFilename;
            return this;
        }

        public Builder keystorePassword(String keystorePass) {
            this.keystorePass = keystorePass;
            return this;
        }

        public Builder keyPassword(String keyPass) {
            this.keyPass = keyPass;
            return this;
        }

        public Builder keystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public Builder truststoreFilename(String truststoreFilename) {
            this.truststoreFilename = truststoreFilename;
            return this;
        }

        public Builder truststorePassword(String truststorePass) {
            this.truststorePass = truststorePass;
            return this;
        }

        public Builder truststoreType(String truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder readTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder httpHeaders(String httpHeaders) {
            this.httpHeaders = Optional.ofNullable(httpHeaders).filter(StringUtils::isNotBlank).map(headers -> headers.split(HTTP_HEADERS_SEPARATOR)).stream().flatMap(Arrays::stream).map(String::trim).map(header -> header.split(HTTP_HEADER_KEY_VALUE_SEPARATOR)).filter(split -> ((String[])split).length == 2).collect(Collectors.toUnmodifiableMap(split -> Optional.ofNullable(split[0]).map(String::trim).orElse(""), split -> Optional.ofNullable(split[1]).map(String::trim).orElse("")));
            return this;
        }

        public Builder maxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public Builder keepAliveDuration(long keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Builder c2RequestCompression(String c2RequestCompression) {
            this.c2RequestCompression = c2RequestCompression;
            return this;
        }

        public Builder c2AssetDirectory(String c2AssetDirectory) {
            this.c2AssetDirectory = c2AssetDirectory;
            return this;
        }

        public Builder c2AssetRepositoryDirectory(String c2AssetRepositoryDirectory) {
            this.c2AssetRepositoryDirectory = c2AssetRepositoryDirectory;
            return this;
        }

        public Builder bootstrapAcknowledgeTimeout(long bootstrapAcknowledgeTimeout) {
            this.bootstrapAcknowledgeTimeout = bootstrapAcknowledgeTimeout;
            return this;
        }

        public Builder c2FlowInfoProcessorBulletinLimit(int c2FlowInfoProcessorBulletinLimit) {
            this.c2FlowInfoProcessorBulletinLimit = c2FlowInfoProcessorBulletinLimit;
            return this;
        }

        public Builder c2FlowInfoProcessorStatusEnabled(boolean c2FlowInfoProcessorStatusEnabled) {
            this.c2FlowInfoProcessorStatusEnabled = c2FlowInfoProcessorStatusEnabled;
            return this;
        }

        public C2ClientConfig build() {
            return new C2ClientConfig(this);
        }
    }
}

