/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools;

import java.io.File;
import java.io.FilenameFilter;

public abstract class FileProcessor {
    protected final boolean isVerbose;
    private final boolean _failFast;
    private final boolean _dontOverwrite;
    private final FilenameFilter _filter;

    public static FilenameFilter getExtensionFilter(final String filenameExt) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (filenameExt == null || name.endsWith(filenameExt)) {
                    return true;
                }
                File f = new File(dir, name);
                return f.isDirectory();
            }
        };
    }

    public FileProcessor(FilenameFilter filter, boolean failFast, boolean overwrite, boolean verbose) {
        this._filter = filter;
        this._failFast = failFast;
        this._dontOverwrite = !overwrite;
        this.isVerbose = verbose;
    }

    public FileProcessor(FilenameFilter filter, boolean verbosity) {
        this(filter, false, true, verbosity);
    }

    public FileProcessor(String extension, boolean verbosity) {
        this(FileProcessor.getExtensionFilter(extension), verbosity);
    }

    public boolean process(File in, File out) {
        if (this.isVerbose) {
            System.out.println("Processing file:" + in + " to file:" + out);
        }
        if (in.isDirectory()) {
            boolean success = true;
            String[] names = in.list(this._filter);
            int sz = names.length;
            for (int i = 0; i < sz; ++i) {
                File subIn = new File(in, names[i]);
                File subOut = new File(out, names[i]);
                if (!this._failFast || (success &= this.process(subIn, subOut))) continue;
                return false;
            }
            return success;
        }
        try {
            if (this._dontOverwrite && out.exists()) {
                if (this.isVerbose) {
                    System.out.println("Skipping file:" + in + " as destination file:" + out + " already exists.");
                }
            } else {
                out.getParentFile().mkdirs();
                this.processFile(in, out);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error processing file:" + in + " to file:" + out);
            e.printStackTrace();
            return false;
        }
    }

    protected abstract void processFile(File var1, File var2) throws Exception;
}

