/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.AnnotatedToken;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.ProgramContext;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.ProgramContextStack;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.Token;

public class JSParserUtils {
    public static void tagEvalCalls(Token funcToken, Token bodyStart, Token bodyEnd) {
        boolean hasEval = false;
        Token token = bodyStart;
        while (token != bodyEnd) {
            if (token.kind == 58 && token.image.equals("eval") && token.next != null && token.next.kind == 61) {
                hasEval = true;
                break;
            }
            token = token.next;
        }
        ((AnnotatedToken)funcToken).setFunctionUsesEval(hasEval);
    }

    public static void pushToken(ProgramContextStack contextStack, AnnotatedToken token) {
        ProgramContext context = (ProgramContext)contextStack.peek();
        context.addToken(token.image, token);
    }

    public static void pushTokens(ProgramContextStack contextStack, Vector v) {
        Enumeration item = v.elements();
        while (item.hasMoreElements()) {
            AnnotatedToken t = (AnnotatedToken)item.nextElement();
            JSParserUtils.pushToken(contextStack, t);
        }
    }

    public static void tagObjectIdentifier(Token objToken, Token end) {
        Token t = objToken.next;
        Token suffixToken = null;
        while (t != end) {
            if (t.kind == 69) {
                JSParserUtils.annotateToken(objToken, -5, null, -1);
                suffixToken = t.next;
                if (suffixToken != null && suffixToken.kind == 58) {
                    JSParserUtils.annotateToken(suffixToken, -6, null, -1);
                }
            }
            if (t.kind == 61 && suffixToken != null) {
                JSParserUtils.annotateToken(suffixToken, -7, null, -1);
            }
            t = t.next;
        }
    }

    public static void tagMethodInvocation(ProgramContextStack contextStack, AnnotatedToken start, AnnotatedToken end) {
        if (JSParserUtils.tagAssertProfilerCalls(contextStack, start, end)) {
            return;
        }
        JSParserUtils.tagLoggerCalls(contextStack, start, end);
    }

    private static boolean tagAssertProfilerCalls(ProgramContextStack contextStack, AnnotatedToken start, AnnotatedToken end) {
        AnnotatedToken token;
        boolean isSpecialType = false;
        boolean isRemovable = false;
        for (token = start; token != end; token = token.getNext()) {
            AnnotatedToken objToken = contextStack.getToken(token.image);
            if ((token.isSpecialClassType() || objToken != null && objToken.isSpecialObjectType()) && token.getKind() == -5) {
                isSpecialType = true;
            }
            if (!isSpecialType || token.getKind() != -7) continue;
            isRemovable = true;
            break;
        }
        if (isRemovable) {
            for (token = start; token != end; token = token.getNext()) {
                token.setRemovable(true);
            }
            if (token.kind == 67) {
                token.setRemovable(true);
            }
        }
        return isRemovable;
    }

    private static boolean tagLoggerCalls(ProgramContextStack contextStack, AnnotatedToken start, AnnotatedToken end) {
        AnnotatedToken token;
        boolean isSpecialType = false;
        boolean isLOGGER = false;
        boolean isRemovable = false;
        for (token = start; token != end; token = token.getNext()) {
            if (token.isSpecialClassType() && token.getKind() == -5) {
                isSpecialType = true;
            }
            if (isSpecialType && token.getKind() == -6 && token.image.equals("LOGGER")) {
                isLOGGER = true;
            }
            if (!isLOGGER || token.getKind() != -7) continue;
            isRemovable = true;
            break;
        }
        if (isRemovable) {
            for (token = start; token != end; token = token.getNext()) {
                token.setRemovable(true);
            }
            if (token.kind == 67) {
                token.setRemovable(true);
            }
        }
        return isRemovable;
    }

    public static void tagAssignmentExpression(ProgramContextStack contextStack, AnnotatedToken varToken, AnnotatedToken lhs, AnnotatedToken op, AnnotatedToken rhs, AnnotatedToken end) {
        AnnotatedToken token;
        boolean isSpecialType = false;
        boolean isRemovable = false;
        ProgramContext context = (ProgramContext)contextStack.peek();
        if (rhs.kind != 58) {
            return;
        }
        for (token = varToken != null ? varToken : lhs; token != end; token = token.getNext()) {
            AnnotatedToken objToken = contextStack.getToken(token.image);
            if ((token.isSpecialClassType() || objToken != null && objToken.isSpecialObjectType()) && token.getKind() == -5) {
                isSpecialType = true;
            }
            if (!isSpecialType || token.getKind() != -7) continue;
            isRemovable = true;
            break;
        }
        if (isRemovable) {
            AnnotatedToken prevToken = lhs;
            for (token = varToken != null ? varToken : lhs; token != end; token = token.getNext()) {
                token.setRemovable(true);
                if (token.getNext().isSpecialClassType() && token.kind == 70) {
                    prevToken.setType(token.next.image);
                    context.addToken(prevToken.image, prevToken);
                }
                prevToken = token;
            }
        }
    }

    public static void annotateToken(Token t, int annotationId, Object annotationObject, int wsSensitive) {
        AnnotatedToken annToken = (AnnotatedToken)t;
        annToken.setAnnotationKind(annotationId);
        if (annotationObject != null) {
            annToken.setAnnotationObject(annotationObject);
        }
        if (wsSensitive >= 0) {
            annToken.setWSSensitive(wsSensitive);
        }
    }

    public static void annotateTokens(Vector v, int annotationId, Object annotationObject, int wsSensitive) {
        Enumeration item = v.elements();
        while (item.hasMoreElements()) {
            Token t = (Token)item.nextElement();
            JSParserUtils.annotateToken(t, annotationId, annotationObject, wsSensitive);
        }
    }
}

