/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.assembler.Assembler;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.assembler.AssemblerReader;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.assembler.AssemblerReaderManager;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.assembler.Script;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class CompileMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.js"};
    private MavenProject project;
    protected File sourceDirectory;
    protected File outputDirectory;
    private String[] excludes;
    private String[] includes;
    private AssemblerReaderManager assemblerReaderManager;
    private File descriptor;
    private String descriptorFormat;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.outputDirectory.mkdirs();
        Set merged = this.assemble();
        if (this.includes == null) {
            this.includes = DEFAULT_INCLUDES;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setExcludes(this.excludes);
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.includes);
        scanner.scan();
        try {
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                if (merged.contains(file)) continue;
                File source = new File(this.sourceDirectory, file);
                File dest = new File(this.outputDirectory, file);
                dest.getParentFile().mkdir();
                FileUtils.copyFile((File)source, (File)dest);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy source files to " + this.outputDirectory, (Exception)e);
        }
    }

    protected Set assemble() throws MojoExecutionException {
        Assembler assembler;
        if (this.descriptor == null) {
            return Collections.EMPTY_SET;
        }
        if (!this.descriptor.exists()) {
            if (this.descriptor.getName().equals(this.project.getArtifactId() + ".xml")) {
                this.getLog().info((CharSequence)"No default assembler descriptor - just copy scripts");
                return Collections.EMPTY_SET;
            }
            throw new MojoExecutionException("The assembler descriptor does not exists : " + this.descriptor);
        }
        if (this.descriptorFormat == null) {
            this.descriptorFormat = "default";
            if (this.descriptor.getName().toLowerCase().endsWith(".jsb")) {
                this.descriptorFormat = "jsbuilder";
            }
        }
        try {
            AssemblerReader reader = this.assemblerReaderManager.getAssemblerReader(this.descriptorFormat);
            assembler = reader.getAssembler(this.descriptor);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read the assembler descriptor " + this.descriptor.getAbsolutePath(), e);
        }
        return this.assemble(assembler);
    }

    private Set assemble(Assembler assembler) throws MojoExecutionException {
        HashSet<String> merged = new HashSet<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setExcludes(this.excludes);
        scanner.addDefaultExcludes();
        for (Script script : assembler.getScripts()) {
            String fileName = script.getFileName();
            PrintWriter writer = null;
            try {
                File target = new File(this.outputDirectory, fileName);
                target.getParentFile().mkdirs();
                writer = new PrintWriter(target);
                List scriptOrderedIncludes = script.getIncludes();
                for (String scriptInclude : scriptOrderedIncludes) {
                    scanner.setIncludes(new String[]{scriptInclude});
                    scanner.scan();
                    String[] files = scanner.getIncludedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        String file = files[i];
                        File source = new File(this.sourceDirectory.getAbsolutePath() + "/" + file);
                        IOUtil.copy((Reader)new FileReader(source), (Writer)writer);
                        writer.println();
                        merged.add(file);
                    }
                }
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Failed to write merged file " + fileName, (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
        }
        return merged;
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

