/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.serial;

import org.apache.mina.integration.beans.AbstractPropertyEditor;
import org.apache.mina.transport.serial.SerialAddress;

public class SerialAddressEditor
extends AbstractPropertyEditor {
    protected String toText(Object value) {
        SerialAddress addr = (SerialAddress)value;
        return addr.getName() + ':' + addr.getBauds() + ':' + this.toText(addr.getDataBits()) + ':' + this.toText(addr.getStopBits()) + ':' + this.toText(addr.getParity()) + ':' + this.toText(addr.getFlowControl());
    }

    private String toText(SerialAddress.DataBits bits) {
        switch (bits) {
            case DATABITS_5: {
                return "5";
            }
            case DATABITS_6: {
                return "6";
            }
            case DATABITS_7: {
                return "7";
            }
            case DATABITS_8: {
                return "8";
            }
        }
        throw new IllegalArgumentException("Unknown dataBits: " + (Object)((Object)bits));
    }

    private String toText(SerialAddress.StopBits bits) {
        switch (bits) {
            case BITS_1: {
                return "1";
            }
            case BITS_1_5: {
                return "1.5";
            }
            case BITS_2: {
                return "2";
            }
        }
        throw new IllegalArgumentException("Unknown stopBits: " + (Object)((Object)bits));
    }

    private String toText(SerialAddress.Parity parity) {
        switch (parity) {
            case EVEN: {
                return "even";
            }
            case ODD: {
                return "odd";
            }
            case MARK: {
                return "mark";
            }
            case NONE: {
                return "none";
            }
            case SPACE: {
                return "space";
            }
        }
        throw new IllegalArgumentException("Unknown parity: " + (Object)((Object)parity));
    }

    private String toText(SerialAddress.FlowControl flowControl) {
        switch (flowControl) {
            case NONE: {
                return "none";
            }
            case RTSCTS_IN: {
                return "rtscts-in";
            }
            case RTSCTS_OUT: {
                return "rtscts-out";
            }
            case XONXOFF_IN: {
                return "xonxoff-in";
            }
            case XONXOFF_OUT: {
                return "xonxoff-out";
            }
        }
        throw new IllegalArgumentException("Unknown flowControl: " + (Object)((Object)flowControl));
    }

    protected Object toValue(String text) throws IllegalArgumentException {
        String[] components = text.split(":");
        if (components.length != 6) {
            throw new IllegalArgumentException("SerialAddress must have 6 components separated by colon: " + text);
        }
        return new SerialAddress(components[0].trim(), this.toBauds(components[1].trim()), this.toDataBits(components[2].trim()), this.toStopBits(components[3].trim()), this.toParity(components[4].trim()), this.toFlowControl(components[5].trim()));
    }

    private int toBauds(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bauds: " + text);
        }
    }

    private SerialAddress.DataBits toDataBits(String text) {
        try {
            return SerialAddress.DataBits.valueOf("DATABITS_" + Integer.parseInt(text));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("dataBits: " + text);
        }
    }

    private SerialAddress.StopBits toStopBits(String text) {
        try {
            return SerialAddress.StopBits.valueOf("BITS_" + text.replace('.', '_'));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("stopBits: " + text);
        }
    }

    private SerialAddress.Parity toParity(String text) {
        try {
            return SerialAddress.Parity.valueOf(text.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("parity: " + text);
        }
    }

    private SerialAddress.FlowControl toFlowControl(String text) {
        String normalizedText = text.toUpperCase().replaceAll("(-|_)", "");
        if (normalizedText.endsWith("IN")) {
            normalizedText = normalizedText.substring(0, normalizedText.length() - 2) + "_IN";
        }
        if (normalizedText.endsWith("OUT")) {
            normalizedText = normalizedText.substring(0, normalizedText.length() - 3) + "_OUT";
        }
        try {
            return SerialAddress.FlowControl.valueOf(normalizedText);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("flowControl: " + text);
        }
    }
}

