/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.serialization;

import java.nio.ByteBuffer;
import org.apache.mina.codec.ProtocolEncoderException;
import org.apache.mina.codec.delimited.ByteBufferEncoder;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftMessageEncoder<INPUT extends TBase<?, ?>>
extends ByteBufferEncoder<INPUT> {
    private final TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
    private INPUT lastMessage;
    private byte[] lastBuffer;

    public static <L extends TBase<?, ?>> ThriftMessageEncoder<L> newInstance(Class<L> clazz) {
        return new ThriftMessageEncoder();
    }

    private byte[] prepareBuffer(INPUT message) throws TException {
        if (message != this.lastMessage) {
            this.lastBuffer = this.serializer.serialize(message);
            this.lastMessage = message;
        }
        return this.lastBuffer;
    }

    public int getEncodedSize(INPUT message) {
        try {
            return this.prepareBuffer(message).length;
        }
        catch (TException e) {
            return 0;
        }
    }

    public void writeTo(INPUT message, ByteBuffer buffer) {
        try {
            buffer.put(this.prepareBuffer(message));
        }
        catch (TException e) {
            throw new ProtocolEncoderException((Throwable)e);
        }
    }
}

