/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.serialization;

import org.apache.mina.codec.IoBuffer;
import org.apache.mina.codec.ProtocolDecoderException;
import org.apache.mina.codec.delimited.IoBufferDecoder;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftMessageDecoder<OUTPUT extends TBase<?, ?>>
extends IoBufferDecoder<OUTPUT> {
    private final TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
    private final Class<OUTPUT> clazz;

    public ThriftMessageDecoder(Class<OUTPUT> clazz) {
        this.clazz = clazz;
    }

    public static <L extends TBase<?, ?>> ThriftMessageDecoder<L> newInstance(Class<L> clazz) {
        return new ThriftMessageDecoder<L>(clazz);
    }

    public OUTPUT decode(IoBuffer input) {
        try {
            byte[] array = new byte[input.remaining()];
            input.get(array);
            TBase object = (TBase)this.clazz.newInstance();
            this.deserializer.deserialize(object, array);
            return (OUTPUT)object;
        }
        catch (TException e) {
            throw new ProtocolDecoderException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ProtocolDecoderException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ProtocolDecoderException((Throwable)e);
        }
    }
}

