/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.transition;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.mina.statemachine.State;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.transition.AbstractTransition;
import org.apache.mina.statemachine.transition.AmbiguousMethodException;
import org.apache.mina.statemachine.transition.MethodInvocationException;
import org.apache.mina.statemachine.transition.NoSuchMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodTransition
extends AbstractTransition {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTransition.class);
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private final Method method;
    private final Object target;

    public MethodTransition(Object eventId, State nextState, Method method, Object target) {
        super(eventId, nextState);
        this.method = method;
        this.target = target;
    }

    public MethodTransition(Object eventId, Method method, Object target) {
        this(eventId, null, method, target);
    }

    public MethodTransition(Object eventId, State nextState, Object target) {
        this(eventId, nextState, eventId.toString(), target);
    }

    public MethodTransition(Object eventId, Object target) {
        this(eventId, eventId.toString(), target);
    }

    public MethodTransition(Object eventId, String methodName, Object target) {
        this(eventId, null, methodName, target);
    }

    public MethodTransition(Object eventId, State nextState, String methodName, Object target) {
        super(eventId, nextState);
        this.target = target;
        Method[] candidates = target.getClass().getMethods();
        Method result = null;
        for (int i = 0; i < candidates.length; ++i) {
            if (!candidates[i].getName().equals(methodName)) continue;
            if (result != null) {
                throw new AmbiguousMethodException(methodName);
            }
            result = candidates[i];
        }
        if (result == null) {
            throw new NoSuchMethodException(methodName);
        }
        this.method = result;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public boolean doExecute(Event event) {
        Class<?>[] types = this.method.getParameterTypes();
        if (types.length == 0) {
            this.invokeMethod(EMPTY_ARGUMENTS);
            return true;
        }
        if (types.length > 2 + event.getArguments().length) {
            return false;
        }
        Object[] args = new Object[types.length];
        int i = 0;
        if (this.match(types[i], event, Event.class)) {
            args[i++] = event;
        }
        if (i < args.length && this.match(types[i], event.getContext(), StateContext.class)) {
            args[i++] = event.getContext();
        }
        Object[] eventArgs = event.getArguments();
        for (int j = 0; i < args.length && j < eventArgs.length; ++j) {
            if (!this.match(types[i], eventArgs[j], Object.class)) continue;
            args[i++] = eventArgs[j];
        }
        if (args.length > i) {
            return false;
        }
        this.invokeMethod(args);
        return true;
    }

    private boolean match(Class<?> paramType, Object arg, Class<?> argType) {
        if (paramType.isPrimitive()) {
            if (paramType.equals(Boolean.TYPE)) {
                return arg instanceof Boolean;
            }
            if (paramType.equals(Integer.TYPE)) {
                return arg instanceof Integer;
            }
            if (paramType.equals(Long.TYPE)) {
                return arg instanceof Long;
            }
            if (paramType.equals(Short.TYPE)) {
                return arg instanceof Short;
            }
            if (paramType.equals(Byte.TYPE)) {
                return arg instanceof Byte;
            }
            if (paramType.equals(Double.TYPE)) {
                return arg instanceof Double;
            }
            if (paramType.equals(Float.TYPE)) {
                return arg instanceof Float;
            }
            if (paramType.equals(Character.TYPE)) {
                return arg instanceof Character;
            }
        }
        return argType.isAssignableFrom(paramType) && paramType.isAssignableFrom(arg.getClass());
    }

    private void invokeMethod(Object[] arguments) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing method " + this.method + " with arguments " + Arrays.asList(arguments));
            }
            this.method.invoke(this.target, arguments);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new MethodInvocationException(this.method, (Throwable)ite);
        }
        catch (IllegalAccessException iae) {
            throw new MethodInvocationException(this.method, (Throwable)iae);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodTransition)) {
            return false;
        }
        MethodTransition that = (MethodTransition)o;
        return this.method.equals(that.method) && this.target.equals(that.target);
    }

    @Override
    public int hashCode() {
        int h = 17;
        h = h * 37 + super.hashCode();
        h = h * 37 + this.method.hashCode();
        h = h * 37 + this.target.hashCode();
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MethodTransition[");
        sb.append(super.toString());
        sb.append(",method=").append(this.method);
        sb.append(']');
        return sb.toString();
    }
}

