/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mina.statemachine.transition.SelfTransition;
import org.apache.mina.statemachine.transition.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private final String id;
    private final State parent;
    private List<TransitionHolder> transitionHolders = new ArrayList<TransitionHolder>();
    private List<Transition> transitions = Collections.emptyList();
    private List<SelfTransition> onEntries = new ArrayList<SelfTransition>();
    private List<SelfTransition> onExits = new ArrayList<SelfTransition>();

    public State(String id) {
        this(id, null);
    }

    public State(String id, State parent) {
        this.id = id;
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public State getParent() {
        return this.parent;
    }

    public List<Transition> getTransitions() {
        return Collections.unmodifiableList(this.transitions);
    }

    public List<SelfTransition> getOnEntrySelfTransitions() {
        return Collections.unmodifiableList(this.onEntries);
    }

    public List<SelfTransition> getOnExitSelfTransitions() {
        return Collections.unmodifiableList(this.onExits);
    }

    State addOnEntrySelfTransaction(SelfTransition onEntrySelfTransaction) {
        if (onEntrySelfTransaction == null) {
            throw new IllegalArgumentException("transition");
        }
        this.onEntries.add(onEntrySelfTransaction);
        return this;
    }

    State addOnExitSelfTransaction(SelfTransition onExitSelfTransaction) {
        if (onExitSelfTransaction == null) {
            throw new IllegalArgumentException("transition");
        }
        this.onExits.add(onExitSelfTransaction);
        return this;
    }

    private void updateTransitions() {
        this.transitions = new ArrayList<Transition>(this.transitionHolders.size());
        for (TransitionHolder holder : this.transitionHolders) {
            this.transitions.add(holder.transition);
        }
    }

    public State addTransition(Transition transition) {
        return this.addTransition(transition, 0);
    }

    public State addTransition(Transition transition, int weight) {
        if (transition == null) {
            throw new IllegalArgumentException("transition");
        }
        this.transitionHolders.add(new TransitionHolder(transition, weight));
        Collections.sort(this.transitionHolders);
        this.updateTransitions();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        return this.id.equals(((State)o).id);
    }

    public int hashCode() {
        int h = 37;
        return h * 17 + this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("State[");
        sb.append("id=").append(this.id);
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransitionHolder
    implements Comparable<TransitionHolder> {
        private Transition transition;
        private int weight;

        TransitionHolder(Transition transition, int weight) {
            this.transition = transition;
            this.weight = weight;
        }

        @Override
        public int compareTo(TransitionHolder o) {
            return this.weight > o.weight ? 1 : (this.weight < o.weight ? -1 : 0);
        }
    }
}

