/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.context;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.statemachine.context.AbstractStateContextLookup;
import org.apache.mina.statemachine.context.DefaultStateContextFactory;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.context.StateContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoSessionStateContextLookup
extends AbstractStateContextLookup {
    public static final String DEFAULT_SESSION_ATTRIBUTE_NAME = IoSessionStateContextLookup.class.getName() + ".stateContext";
    private final String sessionAttributeName;

    public IoSessionStateContextLookup() {
        this(new DefaultStateContextFactory(), DEFAULT_SESSION_ATTRIBUTE_NAME);
    }

    public IoSessionStateContextLookup(String sessionAttributeName) {
        this(new DefaultStateContextFactory(), sessionAttributeName);
    }

    public IoSessionStateContextLookup(StateContextFactory contextFactory) {
        this(contextFactory, DEFAULT_SESSION_ATTRIBUTE_NAME);
    }

    public IoSessionStateContextLookup(StateContextFactory contextFactory, String sessionAttributeName) {
        super(contextFactory);
        this.sessionAttributeName = sessionAttributeName;
    }

    @Override
    protected StateContext lookup(Object eventArg) {
        IoSession session = (IoSession)eventArg;
        return (StateContext)session.getAttribute((Object)this.sessionAttributeName);
    }

    @Override
    protected void store(Object eventArg, StateContext context) {
        IoSession session = (IoSession)eventArg;
        session.setAttribute((Object)this.sessionAttributeName, (Object)context);
    }

    @Override
    protected boolean supports(Class<?> c) {
        return IoSession.class.isAssignableFrom(c);
    }
}

