/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.mina.statemachine.StateMachine;
import org.apache.mina.statemachine.context.SingletonStateContextLookup;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.context.StateContextLookup;
import org.apache.mina.statemachine.event.DefaultEventFactory;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.event.EventArgumentsInterceptor;
import org.apache.mina.statemachine.event.EventFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(StateMachineProxyFactory.class);
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];

    private StateMachineProxyFactory() {
    }

    public static <T> T create(Class<T> iface, StateMachine sm) {
        return (T)StateMachineProxyFactory.create(new Class[]{iface}, sm);
    }

    public static <T> T create(Class<T> iface, StateMachine sm, StateContextLookup contextLookup) {
        return (T)StateMachineProxyFactory.create(new Class[]{iface}, sm, contextLookup);
    }

    public static <T> T create(Class<T> iface, StateMachine sm, StateContextLookup contextLookup, EventArgumentsInterceptor interceptor) {
        return (T)StateMachineProxyFactory.create(new Class[]{iface}, sm, contextLookup, interceptor, (EventFactory)new DefaultEventFactory());
    }

    public static <T> T create(Class<T> iface, StateMachine sm, StateContextLookup contextLookup, EventArgumentsInterceptor interceptor, EventFactory eventFactory) {
        return (T)StateMachineProxyFactory.create(new Class[]{iface}, sm, contextLookup, interceptor, eventFactory);
    }

    public static Object create(Class<?>[] ifaces, StateMachine sm) {
        return StateMachineProxyFactory.create(ifaces, sm, (StateContextLookup)new SingletonStateContextLookup());
    }

    public static Object create(Class<?>[] ifaces, StateMachine sm, StateContextLookup contextLookup) {
        return StateMachineProxyFactory.create(ifaces, sm, contextLookup, null, (EventFactory)new DefaultEventFactory());
    }

    public static Object create(Class<?>[] ifaces, StateMachine sm, StateContextLookup contextLookup, EventArgumentsInterceptor interceptor, EventFactory eventFactory) {
        ClassLoader cl = StateMachineProxyFactory.class.getClassLoader();
        MethodInvocationHandler handler = new MethodInvocationHandler(sm, contextLookup, interceptor, eventFactory);
        return Proxy.newProxyInstance(cl, ifaces, (InvocationHandler)handler);
    }

    private static class MethodInvocationHandler
    implements InvocationHandler {
        private final StateMachine sm;
        private final StateContextLookup contextLookup;
        private final EventArgumentsInterceptor interceptor;
        private final EventFactory eventFactory;

        public MethodInvocationHandler(StateMachine sm, StateContextLookup contextLookup, EventArgumentsInterceptor interceptor, EventFactory eventFactory) {
            this.contextLookup = contextLookup;
            this.sm = sm;
            this.interceptor = interceptor;
            this.eventFactory = eventFactory;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            StateContext context;
            if ("hashCode".equals(method.getName()) && args == null) {
                return new Integer(System.identityHashCode(proxy));
            }
            if ("equals".equals(method.getName()) && args.length == 1) {
                return proxy == args[0];
            }
            if ("toString".equals(method.getName()) && args == null) {
                return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            if (log.isDebugEnabled()) {
                log.debug("Method invoked: " + method);
            }
            Object[] objectArray = args = args == null ? EMPTY_ARGUMENTS : args;
            if (this.interceptor != null) {
                args = this.interceptor.modify(args);
            }
            if ((context = this.contextLookup.lookup(args)) == null) {
                throw new IllegalStateException("Cannot determine state context for method invocation: " + method);
            }
            Event event = this.eventFactory.create(context, method, args);
            this.sm.handle(event);
            return null;
        }
    }
}

