/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.mina.codec.IoBuffer;
import org.apache.mina.codec.ProtocolDecoderException;
import org.apache.mina.codec.delimited.IoBufferDecoder;

public final class ProtobufMessageDecoder<IN extends GeneratedMessage>
extends IoBufferDecoder<IN> {
    private final Method parseMethod;
    private final ExtensionRegistryLite registry;

    public static <TYPE extends GeneratedMessage> ProtobufMessageDecoder<TYPE> newInstance(Class<TYPE> c) throws NoSuchMethodException {
        return ProtobufMessageDecoder.newInstance(c, ExtensionRegistryLite.getEmptyRegistry());
    }

    public static <TYPE extends GeneratedMessage> ProtobufMessageDecoder<TYPE> newInstance(Class<TYPE> c, ExtensionRegistryLite registry) throws NoSuchMethodException {
        return new ProtobufMessageDecoder<TYPE>(c, registry);
    }

    private ProtobufMessageDecoder(Class<IN> clazz, ExtensionRegistryLite registry) throws NoSuchMethodException {
        this.parseMethod = clazz.getDeclaredMethod("parseFrom", InputStream.class, ExtensionRegistryLite.class);
        this.registry = registry;
    }

    public IN decode(IoBuffer input) {
        try {
            return (IN)((GeneratedMessage)this.parseMethod.invoke(null, input.asInputStream(), this.registry));
        }
        catch (Exception e) {
            throw new ProtocolDecoderException((Throwable)e);
        }
    }
}

