/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.ints;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.mina.codec.IoBuffer;
import org.apache.mina.codec.delimited.ByteBufferEncoder;
import org.apache.mina.codec.delimited.IoBufferDecoder;
import org.apache.mina.codec.delimited.ints.IntTranscoder;

public final class RawInt32
implements IntTranscoder {
    private final ByteOrder bo;
    private static final int BYTE_MASK = 255;

    public RawInt32(ByteOrder bo) {
        this.bo = bo == null ? ByteOrder.BIG_ENDIAN : bo;
    }

    @Override
    public IoBufferDecoder<Integer> getDecoder() {
        return new Decoder();
    }

    @Override
    public ByteBufferEncoder<Integer> getEncoder() {
        return new Encoder();
    }

    private class Encoder
    extends ByteBufferEncoder<Integer> {
        private Encoder() {
        }

        @Override
        public void writeTo(Integer message, ByteBuffer buffer) {
            if (buffer.remaining() < 4) {
                throw new BufferUnderflowException();
            }
            for (int i = 0; i < 32; i += 8) {
                buffer.put((byte)(message >> (RawInt32.this.bo == ByteOrder.BIG_ENDIAN ? 24 - i : i)));
            }
        }

        @Override
        public int getEncodedSize(Integer message) {
            return 4;
        }
    }

    private class Decoder
    extends IoBufferDecoder<Integer> {
        private Decoder() {
        }

        @Override
        public Integer decode(IoBuffer input) {
            if (input.remaining() < 4) {
                return null;
            }
            int out = 0;
            for (int i = 0; i < 32; i += 8) {
                out |= (input.get() & 0xFF) << (RawInt32.this.bo == ByteOrder.BIG_ENDIAN ? 24 - i : i);
            }
            return out;
        }
    }
}

