/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.ognl;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.TypeConverter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.integration.ognl.PropertyTypeConverter;

public class IoSessionFinder {
    private final String query;
    private final TypeConverter typeConverter = new PropertyTypeConverter();
    private final Object expression;

    public IoSessionFinder(String query) {
        char c;
        int i;
        if (query == null) {
            throw new IllegalArgumentException("query");
        }
        if ((query = query.trim()).length() == 0) {
            throw new IllegalArgumentException("query is empty.");
        }
        int comp = -1;
        for (i = 0; i < query.length(); ++i) {
            c = query.charAt(i);
            if (c == '=' || c == '<' || c == '>' || c == '!') {
                comp = i;
                continue;
            }
            if (!Character.isJavaIdentifierPart(c) && c != ' ') {
                throw new IllegalArgumentException("Invalid query.");
            }
            if (comp > 0) break;
        }
        if (comp <= 0) {
            throw new IllegalArgumentException("Invalid query.");
        }
        for (i = comp + 1; i < query.length(); ++i) {
            c = query.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == ' ' || c == '\"' || c == '\'') continue;
            throw new IllegalArgumentException("Invalid query.");
        }
        this.query = query;
        try {
            this.expression = Ognl.parseExpression((String)query);
        }
        catch (OgnlException e) {
            throw new IllegalArgumentException("query: " + query);
        }
    }

    public Set<IoSession> find(Iterable<IoSession> sessions) throws OgnlException {
        if (sessions == null) {
            throw new IllegalArgumentException("sessions");
        }
        LinkedHashSet<IoSession> answer = new LinkedHashSet<IoSession>();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("READ_ONLY_MODE", true);
        values.put("QUERY", this.query);
        for (IoSession s : sessions) {
            OgnlContext context = Ognl.createDefaultContext((Object)s, null, (TypeConverter)this.typeConverter).withValues(values);
            Object result = Ognl.getValue((Object)this.expression, (OgnlContext)context, (Object)s);
            if (result instanceof Boolean) {
                if (!((Boolean)result).booleanValue()) continue;
                answer.add(s);
                continue;
            }
            throw new OgnlException("Query didn't return a boolean value: " + this.query);
        }
        return answer;
    }
}

