/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.ognl;

import ognl.ObjectPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;

public abstract class AbstractPropertyAccessor
extends ObjectPropertyAccessor {
    static final Object READ_ONLY_MODE = new Object();
    static final Object QUERY = new Object();

    public final boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        if (oname == null) {
            return false;
        }
        if (this.hasGetProperty0(context, target, oname.toString())) {
            return true;
        }
        return super.hasGetProperty(context, target, oname);
    }

    public final boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        if (context.containsKey(READ_ONLY_MODE)) {
            return true;
        }
        if (oname == null) {
            return false;
        }
        if (this.hasSetProperty0(context, target, oname.toString())) {
            return true;
        }
        return super.hasSetProperty(context, target, oname);
    }

    public final Object getPossibleProperty(OgnlContext context, Object target, String name) throws OgnlException {
        Object answer = this.getProperty0(context, target, name);
        if (answer == OgnlRuntime.NotFound) {
            answer = super.getPossibleProperty(context, target, name);
        }
        return answer;
    }

    public final Object setPossibleProperty(OgnlContext context, Object target, String name, Object value) throws OgnlException {
        if (context.containsKey(READ_ONLY_MODE)) {
            throw new OgnlException("Expression must be read-only: " + context.get(QUERY));
        }
        Object answer = this.setProperty0(context, target, name, value);
        if (answer == OgnlRuntime.NotFound) {
            answer = super.setPossibleProperty(context, target, name, value);
        }
        return answer;
    }

    protected abstract boolean hasGetProperty0(OgnlContext var1, Object var2, String var3) throws OgnlException;

    protected abstract boolean hasSetProperty0(OgnlContext var1, Object var2, String var3) throws OgnlException;

    protected abstract Object getProperty0(OgnlContext var1, Object var2, String var3) throws OgnlException;

    protected abstract Object setProperty0(OgnlContext var1, Object var2, String var3, Object var4) throws OgnlException;
}

