/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.jmx;

import java.net.SocketAddress;
import java.util.Iterator;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.integration.jmx.IoServiceManagerMBean;
import org.apache.mina.management.IoSessionStat;
import org.apache.mina.management.StatCollector;

public class IoServiceManager
implements IoServiceManagerMBean {
    private IoService service;
    private StatCollector collector = null;

    public IoServiceManager(IoService service) {
        this.service = service;
    }

    public int getManagedSessionCount() {
        int count = 0;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            count += this.service.getManagedSessions(element).size();
        }
        return count;
    }

    public void startCollectingStats(int millisecondsPolling) {
        if (this.collector != null && this.collector.isRunning()) {
            throw new RuntimeException("Already collecting stats");
        }
        this.collector = new StatCollector(this.service, millisecondsPolling);
        this.collector.start();
    }

    public void stopCollectingStats() {
        if (this.collector != null && this.collector.isRunning()) {
            this.collector.stop();
        }
    }

    public float getTotalByteReadThroughput() {
        float total = 0.0f;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getByteReadThroughput();
            }
        }
        return total;
    }

    public float getTotalByteWrittenThroughput() {
        float total = 0.0f;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getByteWrittenThroughput();
            }
        }
        return total;
    }

    public float getTotalMessageReadThroughput() {
        float total = 0.0f;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getMessageReadThroughput();
            }
        }
        return total;
    }

    public float getTotalMessageWrittenThroughput() {
        float total = 0.0f;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getMessageWrittenThroughput();
            }
        }
        return total;
    }

    public float getAverageByteReadThroughput() {
        float total = 0.0f;
        int count = 0;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getByteReadThroughput();
                ++count;
            }
        }
        return total / (float)count;
    }

    public float getAverageByteWrittenThroughput() {
        float total = 0.0f;
        int count = 0;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getByteWrittenThroughput();
                ++count;
            }
        }
        return total / (float)count;
    }

    public float getAverageMessageReadThroughput() {
        float total = 0.0f;
        int count = 0;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getMessageReadThroughput();
                ++count;
            }
        }
        return total / (float)count;
    }

    public float getAverageMessageWrittenThroughput() {
        float total = 0.0f;
        int count = 0;
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                total += ((IoSessionStat)session.getAttribute(StatCollector.KEY)).getMessageWrittenThroughput();
                ++count;
            }
        }
        return total / (float)count;
    }

    public void closeAllSessions() {
        Iterator iter = this.service.getManagedServiceAddresses().iterator();
        while (iter.hasNext()) {
            SocketAddress element = (SocketAddress)iter.next();
            Iterator iter2 = this.service.getManagedSessions(element).iterator();
            while (iter2.hasNext()) {
                IoSession session = (IoSession)iter2.next();
                session.close();
            }
        }
    }
}

