/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.mina.codec.ProtocolDecoder;
import org.apache.mina.http.ArrayUtil;
import org.apache.mina.http.DecoderState;
import org.apache.mina.http.HttpDecoderState;
import org.apache.mina.http.HttpRequestImpl;
import org.apache.mina.http.api.HttpContentChunk;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpPdu;
import org.apache.mina.http.api.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerDecoder
implements ProtocolDecoder<ByteBuffer, HttpPdu, HttpDecoderState> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerDecoder.class);
    public static final Pattern REQUEST_LINE_PATTERN = Pattern.compile(" ");
    public static final Pattern QUERY_STRING_PATTERN = Pattern.compile("\\?");
    public static final Pattern PARAM_STRING_PATTERN = Pattern.compile("\\&|;");
    public static final Pattern KEY_VALUE_PATTERN = Pattern.compile("=");
    public static final Pattern RAW_VALUE_PATTERN = Pattern.compile("\\r\\n\\r\\n");
    public static final Pattern HEADERS_BODY_PATTERN = Pattern.compile("\\r\\n");
    public static final Pattern HEADER_VALUE_PATTERN = Pattern.compile(":");
    public static final Pattern COOKIE_SEPARATOR_PATTERN = Pattern.compile(";");

    public HttpDecoderState createDecoderState() {
        return new HttpDecoderState();
    }

    public HttpPdu decode(ByteBuffer msg, HttpDecoderState context) {
        LOG.debug("decode : {}", (Object)msg);
        if (msg.remaining() <= 0) {
            return null;
        }
        switch (context.getState()) {
            case HEAD: {
                LOG.debug("decoding HEAD");
                msg = ByteBuffer.allocate(context.getPartial().remaining() + msg.remaining()).put(context.getPartial()).put(msg);
                msg.flip();
            }
            case NEW: {
                LOG.debug("decoding NEW");
                HttpRequestImpl rq = this.parseHttpRequestHead(msg);
                if (rq != null) {
                    return rq;
                }
                context.setPartial(ByteBuffer.allocate(msg.remaining()));
                context.getPartial().put(msg);
                context.getPartial().flip();
                return null;
            }
            case BODY: {
                LOG.debug("decoding BODY");
                int chunkSize = msg.remaining();
                HttpContentChunk chunk = new HttpContentChunk(msg);
                context.setRemainingBytes(context.getRemainingBytes() - chunkSize);
                if (context.getRemainingBytes() > 0) break;
                LOG.debug("end of HTTP body");
                context.setState(DecoderState.NEW);
                context.setRemainingBytes(0);
                context.setState(DecoderState.DONE);
                return chunk;
            }
            case DONE: {
                return new HttpEndOfContent();
            }
            default: {
                throw new IllegalStateException("Unknonwn decoder state : " + (Object)((Object)context.getState()));
            }
        }
        return null;
    }

    private HttpRequestImpl parseHttpRequestHead(ByteBuffer buffer) {
        String raw = new String(buffer.array(), 0, buffer.limit(), Charset.forName("ISO-8859-1"));
        String[] headersAndBody = RAW_VALUE_PATTERN.split(raw, -1);
        if (headersAndBody.length <= 1) {
            return null;
        }
        String[] headerFields = HEADERS_BODY_PATTERN.split(headersAndBody[0]);
        headerFields = ArrayUtil.dropFromEndWhile(headerFields, "");
        String requestLine = headerFields[0];
        HashMap<String, String> generalHeaders = new HashMap<String, String>();
        for (int i = 1; i < headerFields.length; ++i) {
            String[] header = HEADER_VALUE_PATTERN.split(headerFields[i]);
            generalHeaders.put(header[0].toLowerCase(), header[1].trim());
        }
        String[] elements = REQUEST_LINE_PATTERN.split(requestLine);
        HttpMethod method = HttpMethod.valueOf(elements[0]);
        HttpVersion version = HttpVersion.fromString(elements[2]);
        String[] pathFrags = QUERY_STRING_PATTERN.split(elements[1]);
        String requestedPath = pathFrags[0];
        buffer.position(headersAndBody[0].length() + 4);
        return new HttpRequestImpl(version, method, requestedPath, generalHeaders);
    }

    public void finishDecode(HttpDecoderState context) {
    }
}

