/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http.api;

public enum HttpVersion {
    HTTP_1_0("HTTP/1.0"),
    HTTP_1_1("HTTP/1.1"),
    HTTP_1_2("HTTP/1.2"),
    HTTP_1_3("HTTP/1.3");

    private final String value;

    private HttpVersion(String value) {
        this.value = value;
    }

    public static HttpVersion fromString(String httpVersion) {
        if (httpVersion == null) {
            return null;
        }
        switch (httpVersion.toUpperCase()) {
            case "HTTP/1.0": {
                return HTTP_1_0;
            }
            case "HTTP/1.1": {
                return HTTP_1_1;
            }
            case "HTTP/1.2": {
                return HTTP_1_2;
            }
            case "HTTP/1.3": {
                return HTTP_1_3;
            }
        }
        return null;
    }

    public String toString() {
        return this.value;
    }
}

