/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DateUtil {
    private static final Locale LOCALE = Locale.US;
    private static final TimeZone GMT_ZONE;
    private static final String RFC_1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final DateFormat RFC_1123_FORMAT;
    private static final Pattern DIGIT_PATTERN;

    public static String getCurrentAsString() {
        return RFC_1123_FORMAT.format(new Date());
    }

    private static long parseDateStringToMilliseconds(String dateString) {
        try {
            return RFC_1123_FORMAT.parse(dateString).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static long parseToMilliseconds(String dateValue) {
        long ms = 0L;
        ms = DIGIT_PATTERN.matcher(dateValue).matches() ? Long.parseLong(dateValue) : DateUtil.parseDateStringToMilliseconds(dateValue);
        return ms;
    }

    public static String parseToRFC1123(long dateValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateValue);
        return RFC_1123_FORMAT.format(calendar.getTime());
    }

    public static String getDateAsString(Date date) {
        return RFC_1123_FORMAT.format(date);
    }

    static {
        DIGIT_PATTERN = Pattern.compile("^\\d+$");
        RFC_1123_FORMAT = new SimpleDateFormat(RFC_1123_PATTERN, LOCALE);
        GMT_ZONE = TimeZone.getTimeZone("GMT");
        RFC_1123_FORMAT.setTimeZone(GMT_ZONE);
    }
}

