/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.udpecho;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.mina.api.AbstractIoHandler;
import org.apache.mina.api.IdleStatus;
import org.apache.mina.api.IoFilter;
import org.apache.mina.api.IoHandler;
import org.apache.mina.api.IoSession;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filterchain.ReadFilterChainController;
import org.apache.mina.filterchain.WriteFilterChainController;
import org.apache.mina.session.WriteRequest;
import org.apache.mina.transport.nio.NioUdpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioUdpEchoServer {
    static final Logger LOG = LoggerFactory.getLogger(NioUdpEchoServer.class);

    public static void main(String[] args) {
        LOG.info("starting echo server");
        NioUdpServer server = new NioUdpServer();
        server.setFilters(new IoFilter[]{new LoggingFilter("LoggingFilter1"), new IoFilter(){

            public void sessionOpened(IoSession session) {
                LOG.info("session {} open", (Object)session);
            }

            public void sessionIdle(IoSession session, IdleStatus status) {
                LOG.info("session {} idle", (Object)session);
            }

            public void sessionClosed(IoSession session) {
                LOG.info("session {} open", (Object)session);
            }

            public void messageWriting(IoSession session, WriteRequest message, WriteFilterChainController controller) {
                controller.callWriteNextFilter(message);
            }

            public void messageReceived(IoSession session, Object message, ReadFilterChainController controller) {
                if (message instanceof ByteBuffer) {
                    LOG.info("echoing");
                    session.write(message);
                }
            }

            public void messageSent(IoSession session, Object message) {
                LOG.info("message {} sent", message);
            }
        }});
        server.setIoHandler((IoHandler)new AbstractIoHandler(){

            public void sessionOpened(IoSession session) {
                LOG.info("session opened {}", (Object)session);
                String welcomeStr = "welcome\n";
                ByteBuffer bf = ByteBuffer.allocate("welcome\n".length());
                bf.put("welcome\n".getBytes());
                bf.flip();
                session.write((Object)bf);
            }
        });
        try {
            InetSocketAddress address = new InetSocketAddress(9999);
            server.bind((SocketAddress)address);
            LOG.debug("Running the server for 25 sec");
            Thread.sleep(25000L);
            LOG.debug("Unbinding the UDP port");
            server.unbind();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted exception", (Throwable)e);
        }
    }
}

