/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.http;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.mina.api.AbstractIoFilter;
import org.apache.mina.api.IoFilter;
import org.apache.mina.api.IoSession;
import org.apache.mina.codec.ProtocolDecoder;
import org.apache.mina.codec.ProtocolEncoder;
import org.apache.mina.examples.http.BogusSslContextFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filterchain.ReadFilterChainController;
import org.apache.mina.http.DateUtil;
import org.apache.mina.http.HttpServerDecoder;
import org.apache.mina.http.HttpServerEncoder;
import org.apache.mina.http.api.DefaultHttpResponse;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpRequest;
import org.apache.mina.http.api.HttpStatus;
import org.apache.mina.http.api.HttpVersion;
import org.apache.mina.transport.nio.NioTcpServer;

public class HttpsTest {
    public static void main(String[] args) throws Exception {
        NioTcpServer httpServer = new NioTcpServer();
        httpServer.setFilters(new IoFilter[]{new LoggingFilter("INCOMING"), new ProtocolCodecFilter((ProtocolEncoder)new HttpServerEncoder(), (ProtocolDecoder)new HttpServerDecoder()), new LoggingFilter("DECODED"), new DummyHttpSever()});
        httpServer.getSessionConfig().setTcpNoDelay(true);
        httpServer.getSessionConfig().setSslContext(BogusSslContextFactory.getInstance(true));
        httpServer.bind((SocketAddress)new InetSocketAddress(8080));
        Thread.sleep(20000L);
        httpServer.unbind();
    }

    private static class DummyHttpSever
    extends AbstractIoFilter {
        private HttpRequest incomingRequest;
        private List<ByteBuffer> body;

        private DummyHttpSever() {
        }

        public void messageReceived(IoSession session, Object message, ReadFilterChainController controller) {
            if (message instanceof HttpRequest) {
                this.incomingRequest = (HttpRequest)message;
                this.body = new ArrayList<ByteBuffer>();
                if (this.incomingRequest.getMethod() != HttpMethod.POST && this.incomingRequest.getMethod() != HttpMethod.PUT) {
                    this.sendResponse(session, this.incomingRequest);
                }
            } else if (message instanceof ByteBuffer) {
                this.body.add((ByteBuffer)message);
            } else if (message instanceof HttpEndOfContent) {
                this.sendResponse(session, this.incomingRequest);
            }
        }

        public void sendResponse(IoSession session, HttpRequest request) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Server", "Apache MINA Dummy test server/0.0.");
            headers.put("Date", DateUtil.getCurrentAsString());
            headers.put("Connection", "Close");
            String strContent = "Hello ! we reply to request !";
            ByteBuffer content = ByteBuffer.wrap(strContent.getBytes());
            headers.put("Content-Length", String.valueOf(content.remaining()));
            session.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpStatus.SUCCESS_OK, headers));
            session.write((Object)content);
            session.write((Object)new HttpEndOfContent());
        }
    }
}

