/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.sumup.message.AbstractMessage;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    private final int type;
    private int sequence;
    private boolean readHeader;

    protected AbstractMessageDecoder(int type) {
        this.type = type;
    }

    public MessageDecoderResult decodable(IoSession session, IoBuffer in) {
        if (in.remaining() < 6) {
            return MessageDecoderResult.NEED_DATA;
        }
        if (this.type == in.getShort()) {
            return MessageDecoderResult.OK;
        }
        return MessageDecoderResult.NOT_OK;
    }

    public MessageDecoderResult decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        AbstractMessage m;
        if (!this.readHeader) {
            in.getShort();
            this.sequence = in.getInt();
            this.readHeader = true;
        }
        if ((m = this.decodeBody(session, in)) == null) {
            return MessageDecoderResult.NEED_DATA;
        }
        this.readHeader = false;
        m.setSequence(this.sequence);
        out.write((Object)m);
        return MessageDecoderResult.OK;
    }

    protected abstract AbstractMessage decodeBody(IoSession var1, IoBuffer var2);
}

