/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.netcat;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.netcat.NetCatProtocolHandler;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println(Main.class.getName() + " <hostname> <port>");
            return;
        }
        NioSocketConnector connector = new NioSocketConnector();
        connector.setConnectTimeoutMillis(30000L);
        connector.setHandler((IoHandler)new NetCatProtocolHandler());
        ConnectFuture cf = connector.connect((SocketAddress)new InetSocketAddress(args[0], Integer.parseInt(args[1])));
        cf.awaitUninterruptibly();
        cf.getSession().getCloseFuture().awaitUninterruptibly();
        connector.dispose();
    }
}

