/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tcp.perf;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.tcp.perf.BogusSslContextFactory;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class TcpSslClient
extends IoHandlerAdapter {
    private IoConnector connector;
    private static IoSession session;
    private IoBuffer buffer = IoBuffer.allocate((int)8);
    private long t0;
    private long t1;
    private CountDownLatch counter;

    public TcpSslClient() throws GeneralSecurityException {
        this.connector = new NioSocketConnector();
        SSLContext sslContext = BogusSslContextFactory.getInstance(false);
        SslFilter sslFilter = new SslFilter(sslContext);
        sslFilter.setUseClientMode(true);
        this.connector.getFilterChain().addFirst("sslFilter", (IoFilter)sslFilter);
        this.connector.setHandler((IoHandler)this);
        ConnectFuture connFuture = this.connector.connect((SocketAddress)new InetSocketAddress("localhost", 18567));
        connFuture.awaitUninterruptibly();
        session = connFuture.getSession();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        long received = ((IoBuffer)message).getLong();
        if (received != this.counter.getCount()) {
            System.out.println("Error !");
            session.closeNow();
        } else if (this.counter.getCount() == 0L) {
            this.t1 = System.currentTimeMillis();
            System.out.println("------------->  end " + (this.t1 - this.t0));
            session.closeNow();
        } else {
            this.counter.countDown();
            this.buffer.flip();
            this.buffer.putLong(this.counter.getCount());
            this.buffer.flip();
            session.write((Object)this.buffer);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (this.counter.getCount() % 10000L == 0L) {
            System.out.println("Sent " + this.counter + " messages");
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    public static void main(String[] args) throws Exception {
        TcpSslClient client = new TcpSslClient();
        client.t0 = System.currentTimeMillis();
        client.counter = new CountDownLatch(100000);
        client.buffer.putLong(client.counter.getCount());
        client.buffer.flip();
        session.write((Object)client.buffer);
        for (int nbSeconds = 0; client.counter.getCount() > 0L && nbSeconds < 120; ++nbSeconds) {
            client.counter.await(1L, TimeUnit.SECONDS);
        }
        client.connector.dispose(true);
    }
}

