/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.udp.perf;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;

public class UdpClient
extends IoHandlerAdapter {
    private IoConnector connector = new NioDatagramConnector();
    private static IoSession session;

    public UdpClient() {
        this.connector.setHandler((IoHandler)this);
        DatagramSessionConfig dcfg = (DatagramSessionConfig)this.connector.getSessionConfig();
        ConnectFuture connFuture = this.connector.connect((SocketAddress)new InetSocketAddress("localhost", 18567));
        connFuture.awaitUninterruptibly();
        session = connFuture.getSession();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    public static void main(String[] args) throws Exception {
        UdpClient client = new UdpClient();
        long t0 = System.currentTimeMillis();
        for (int i = 0; i <= 100000; ++i) {
            Thread.sleep(1L);
            String str = Integer.toString(i);
            byte[] data = str.getBytes();
            IoBuffer buffer = IoBuffer.allocate((int)data.length);
            buffer.put(data);
            buffer.flip();
            session.write((Object)buffer);
            if (i % 10000 != 0) continue;
            System.out.println("Sent " + i + " messages");
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Sent messages delay : " + (t1 - t0));
        Thread.sleep(100000L);
        client.connector.dispose(true);
    }
}

