/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat.client;

import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.echoserver.ssl.BogusSslContextFactory;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class ChatClientSupport {
    private final IoHandler handler;
    private final String name;
    private IoSession session;

    public ChatClientSupport(String name, IoHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
    }

    public boolean connect(NioSocketConnector connector, SocketAddress address, boolean useSsl) {
        if (this.session != null && this.session.isConnected()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        try {
            LoggingFilter LOGGING_FILTER = new LoggingFilter();
            ProtocolCodecFilter CODEC_FILTER = new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory());
            connector.getFilterChain().addLast("mdc", (IoFilter)new MdcInjectionFilter());
            connector.getFilterChain().addLast("codec", (IoFilter)CODEC_FILTER);
            connector.getFilterChain().addLast("logger", (IoFilter)LOGGING_FILTER);
            if (useSsl) {
                SSLContext sslContext = BogusSslContextFactory.getInstance(false);
                SslFilter sslFilter = new SslFilter(sslContext);
                sslFilter.setUseClientMode(true);
                connector.getFilterChain().addLast("sslFilter", (IoFilter)sslFilter);
            }
            connector.setHandler(this.handler);
            ConnectFuture future1 = connector.connect(address);
            future1.awaitUninterruptibly();
            if (!future1.isConnected()) {
                return false;
            }
            this.session = future1.getSession();
            this.login();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login() {
        this.session.write((Object)("LOGIN " + this.name));
    }

    public void broadcast(String message) {
        this.session.write((Object)("BROADCAST " + message));
    }

    public void quit() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                this.session.write((Object)"QUIT");
                this.session.getCloseFuture().awaitUninterruptibly();
            }
            this.session.close(true);
        }
    }
}

