/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.udp;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.udp.ClientPanel;
import org.apache.mina.example.udp.MemoryMonitorHandler;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;

public class MemoryMonitor {
    private static final long serialVersionUID = 1L;
    public static final int PORT = 18567;
    protected static final Dimension PANEL_SIZE = new Dimension(300, 200);
    private JFrame frame;
    private JTabbedPane tabbedPane;
    private ConcurrentHashMap<SocketAddress, ClientPanel> clients;

    public MemoryMonitor() throws IOException {
        NioDatagramAcceptor acceptor = new NioDatagramAcceptor();
        acceptor.setHandler((IoHandler)new MemoryMonitorHandler(this));
        DefaultIoFilterChainBuilder chain = acceptor.getFilterChain();
        chain.addLast("logger", (IoFilter)new LoggingFilter());
        DatagramSessionConfig dcfg = acceptor.getSessionConfig();
        dcfg.setReuseAddress(true);
        this.frame = new JFrame("Memory monitor");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Welcome", this.createWelcomePanel());
        this.frame.add((Component)this.tabbedPane, "Center");
        this.clients = new ConcurrentHashMap();
        this.frame.pack();
        this.frame.setLocation(300, 300);
        this.frame.setVisible(true);
        acceptor.bind(new SocketAddress[]{new InetSocketAddress(18567)});
        System.out.println("UDPServer listening on port 18567");
    }

    private JPanel createWelcomePanel() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(PANEL_SIZE);
        panel.add(new JLabel("Welcome to the Memory Monitor"));
        return panel;
    }

    protected void recvUpdate(SocketAddress clientAddr, long update) {
        ClientPanel clientPanel = this.clients.get(clientAddr);
        if (clientPanel != null) {
            clientPanel.updateTextField(update);
        } else {
            System.err.println("Received update from unknown client");
        }
    }

    protected void addClient(SocketAddress clientAddr) {
        if (!this.containsClient(clientAddr)) {
            ClientPanel clientPanel = new ClientPanel(clientAddr.toString());
            this.tabbedPane.add(clientAddr.toString(), clientPanel);
            this.clients.put(clientAddr, clientPanel);
        }
    }

    protected boolean containsClient(SocketAddress clientAddr) {
        return this.clients.contains(clientAddr);
    }

    protected void removeClient(SocketAddress clientAddr) {
        this.clients.remove(clientAddr);
    }

    public static void main(String[] args) throws IOException {
        new MemoryMonitor();
    }
}

