/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.imagine.step3.server;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.imagine.step1.ImageRequest;
import org.apache.mina.example.imagine.step1.ImageResponse;
import org.apache.mina.integration.jmx.IoSessionMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServerIoHandler
extends IoHandlerAdapter {
    private static final String characters = "mina rocks abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String INDEX_KEY = ImageServerIoHandler.class.getName() + ".INDEX";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MBeanServer mBeanServer;

    public ImageServerIoHandler(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void sessionCreated(IoSession session) throws Exception {
        IoSessionMBean sessionMBean = new IoSessionMBean(session);
        ObjectName sessionName = new ObjectName(session.getClass().getPackage().getName() + ":type=session,name=" + session.getClass().getSimpleName() + "-" + session.getId());
        this.mBeanServer.registerMBean(sessionMBean, sessionName);
    }

    public void sessionOpened(IoSession session) throws Exception {
        session.setAttribute((Object)INDEX_KEY, (Object)0);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.logger.warn(cause.getMessage(), cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ImageRequest request = (ImageRequest)message;
        String text1 = this.generateString(session, request.getNumberOfCharacters());
        String text2 = this.generateString(session, request.getNumberOfCharacters());
        BufferedImage image1 = this.createImage(request, text1);
        BufferedImage image2 = this.createImage(request, text2);
        ImageResponse response = new ImageResponse(image1, image2);
        session.write((Object)response);
    }

    private BufferedImage createImage(ImageRequest request, String text) {
        BufferedImage image = new BufferedImage(request.getWidth(), request.getHeight(), 13);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.YELLOW);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        Font serif = new Font("serif", 0, 30);
        graphics.setFont(serif);
        graphics.setColor(Color.BLUE);
        ((Graphics)graphics).drawString(text, 10, 50);
        return image;
    }

    private String generateString(IoSession session, int length) {
        Integer index = (Integer)session.getAttribute((Object)INDEX_KEY);
        StringBuilder buffer = new StringBuilder(length);
        while (buffer.length() < length) {
            buffer.append(characters.charAt(index));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            if (index < characters.length()) continue;
            index = 0;
        }
        session.setAttribute((Object)INDEX_KEY, (Object)index);
        return buffer.toString();
    }
}

