/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tapedeck;

import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.tapedeck.CommandSyntaxException;
import org.apache.mina.example.tapedeck.EjectCommand;
import org.apache.mina.example.tapedeck.InfoCommand;
import org.apache.mina.example.tapedeck.ListCommand;
import org.apache.mina.example.tapedeck.LoadCommand;
import org.apache.mina.example.tapedeck.PauseCommand;
import org.apache.mina.example.tapedeck.PlayCommand;
import org.apache.mina.example.tapedeck.QuitCommand;
import org.apache.mina.example.tapedeck.StopCommand;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineDecoder;

public class CommandDecoder
extends TextLineDecoder {
    public CommandDecoder() {
        super(Charset.forName("UTF8"), LineDelimiter.WINDOWS);
    }

    private Object parseCommand(String line) throws CommandSyntaxException {
        String arg;
        String[] temp = line.split(" +", 2);
        String cmd = temp[0].toLowerCase();
        String string = arg = temp.length > 1 ? temp[1] : null;
        if ("load".equals(cmd)) {
            if (arg == null) {
                throw new CommandSyntaxException("No tape number specified");
            }
            try {
                return new LoadCommand(Integer.parseInt(arg));
            }
            catch (NumberFormatException nfe) {
                throw new CommandSyntaxException("Illegal tape number: " + arg);
            }
        }
        if ("play".equals(cmd)) {
            return new PlayCommand();
        }
        if ("pause".equals(cmd)) {
            return new PauseCommand();
        }
        if ("stop".equals(cmd)) {
            return new StopCommand();
        }
        if ("list".equals(cmd)) {
            return new ListCommand();
        }
        if ("eject".equals(cmd)) {
            return new EjectCommand();
        }
        if ("quit".equals(cmd)) {
            return new QuitCommand();
        }
        if ("info".equals(cmd)) {
            return new InfoCommand();
        }
        throw new CommandSyntaxException("Unknown command: " + cmd);
    }

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        final LinkedList lines = new LinkedList();
        super.decode(session, in, new ProtocolDecoderOutput(){

            public void write(Object message) {
                lines.add((String)message);
            }

            public void flush() {
            }
        });
        for (String s : lines) {
            out.write(this.parseCommand(s));
        }
    }
}

