/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.proxy;

import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIoException;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.example.proxy.AbstractProxyIoHandler;
import org.apache.mina.example.proxy.ServerToProxyIoHandler;

public class ClientToProxyIoHandler
extends AbstractProxyIoHandler {
    private final ServerToProxyIoHandler connectorHandler = new ServerToProxyIoHandler();
    private final IoConnector connector;
    private final SocketAddress remoteAddress;

    public ClientToProxyIoHandler(IoConnector connector, SocketAddress remoteAddress) {
        this.connector = connector;
        this.remoteAddress = remoteAddress;
        connector.setHandler((IoHandler)this.connectorHandler);
    }

    public void sessionOpened(final IoSession session) throws Exception {
        this.connector.connect(this.remoteAddress).addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ConnectFuture future) {
                try {
                    future.getSession().setAttribute((Object)session);
                    session.setAttribute((Object)future.getSession());
                    future.getSession().setTrafficMask(TrafficMask.ALL);
                }
                catch (RuntimeIoException e) {
                    session.close();
                }
                finally {
                    session.setTrafficMask(TrafficMask.ALL);
                }
            }
        });
    }
}

