/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.httpserver.codec.HttpResponseMessage;
import org.apache.mina.util.SessionLog;

public class ServerHandler
extends IoHandlerAdapter {
    public void sessionOpened(IoSession session) {
        session.setIdleTime(IdleStatus.BOTH_IDLE, 60);
    }

    public void messageReceived(IoSession session, Object message) {
        HttpResponseMessage response = new HttpResponseMessage();
        response.setContentType("text/plain");
        response.setResponseCode(200);
        response.appendBody("CONNECTED");
        if (response != null) {
            session.write((Object)response).join();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        SessionLog.info((IoSession)session, (String)"Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

