/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.example.httpserver.codec.HttpServerProtocolCodecFactory;
import org.apache.mina.example.httpserver.codec.ServerHandler;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class Server {
    private static int DEFAULT_PORT = 8080;
    public static final String VERSION_STRING = "$Revision: 448084 $ $Date: 2006-09-20 15:13:57 +0900 (\uc218, 20  9\uc6d4 2006) $";

    public static void main(String[] args) {
        int port = DEFAULT_PORT;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port")) continue;
            port = Integer.parseInt(args[i + 1]);
        }
        try {
            SocketAcceptor acceptor = new SocketAcceptor();
            SocketAcceptorConfig cfg = new SocketAcceptorConfig();
            cfg.setReuseAddress(true);
            cfg.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new HttpServerProtocolCodecFactory()));
            cfg.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
            acceptor.bind((SocketAddress)new InetSocketAddress(port), (IoHandler)new ServerHandler(), (IoServiceConfig)cfg);
            System.out.println("Server now listening on port " + port);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

