/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.sumup.message.AddMessage;
import org.apache.mina.example.sumup.message.ResultMessage;
import org.apache.mina.util.SessionLog;

public class ClientSessionHandler
extends IoHandlerAdapter {
    private final int[] values;
    private boolean finished;

    public ClientSessionHandler(int[] values) {
        this.values = values;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void sessionOpened(IoSession session) {
        for (int i = 0; i < this.values.length; ++i) {
            AddMessage m = new AddMessage();
            m.setSequence(i);
            m.setValue(this.values[i]);
            session.write((Object)m);
        }
    }

    public void messageReceived(IoSession session, Object message) {
        ResultMessage rm = (ResultMessage)message;
        if (rm.isOk()) {
            if (rm.getSequence() == this.values.length - 1) {
                SessionLog.info((IoSession)session, (String)("The sum: " + rm.getValue()));
                session.close();
                this.finished = true;
            }
        } else {
            SessionLog.warn((IoSession)session, (String)"Server error, disconnecting...");
            session.close();
            this.finished = true;
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

