/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.chat.ChatCommand;
import org.apache.mina.util.SessionLog;

public class ChatProtocolHandler
extends IoHandlerAdapter {
    private Set sessions = Collections.synchronizedSet(new HashSet());
    private Set users = Collections.synchronizedSet(new HashSet());

    public void exceptionCaught(IoSession session, Throwable cause) {
        SessionLog.error((IoSession)session, (String)"", (Throwable)cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        String theMessage = (String)message;
        String[] result = theMessage.split(" ", 2);
        String theCommand = result[0];
        try {
            ChatCommand command = ChatCommand.valueOf(theCommand);
            String user = (String)session.getAttribute("user");
            switch (command.toInt()) {
                case 1: {
                    session.write((Object)"QUIT OK");
                    session.close();
                    break;
                }
                case 0: {
                    if (user != null) {
                        session.write((Object)("LOGIN ERROR user " + user + " already logged in."));
                        return;
                    }
                    if (result.length != 2) {
                        session.write((Object)"LOGIN ERROR invalid login command.");
                        return;
                    }
                    user = result[1];
                    if (this.users.contains(user)) {
                        session.write((Object)("LOGIN ERROR the name " + user + " is already used."));
                        return;
                    }
                    this.sessions.add(session);
                    session.setAttribute("user", (Object)user);
                    this.users.add(user);
                    session.write((Object)"LOGIN OK");
                    this.broadcast("The user " + user + " has joined the chat session.");
                    break;
                }
                case 2: {
                    if (result.length == 2) {
                        this.broadcast(user + ": " + result[1]);
                    }
                    break;
                }
                default: {
                    SessionLog.info((IoSession)session, (String)("Unhandled command: " + command));
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            SessionLog.debug((IoSession)session, (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(String message) {
        Set set = this.sessions;
        synchronized (set) {
            Iterator iter = this.sessions.iterator();
            while (iter.hasNext()) {
                IoSession s = (IoSession)iter.next();
                if (!s.isConnected()) continue;
                s.write((Object)("BROADCAST OK " + message));
            }
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        String user = (String)session.getAttribute("user");
        this.users.remove(user);
        this.sessions.remove(session);
        this.broadcast("The user " + user + " has left the chat session.");
    }

    public boolean isChatUser(String name) {
        return this.users.contains(name);
    }

    public int getNumberOfUsers() {
        return this.users.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kick(String name) {
        Set set = this.sessions;
        synchronized (set) {
            Iterator iter = this.sessions.iterator();
            while (iter.hasNext()) {
                IoSession s = (IoSession)iter.next();
                if (!name.equals(s.getAttribute("user"))) continue;
                s.close();
                break;
            }
        }
    }
}

