/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private boolean elastic = false;

    public ByteBufferOutputStream() {
        this(1024);
    }

    private ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferOutputStream(int initialSize) {
        this(ByteBuffer.allocate(initialSize));
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer out = this.buffer.asReadOnlyBuffer();
        out.limit(out.position());
        out.position(0);
        return out;
    }

    public boolean isElastic() {
        return this.elastic;
    }

    private void needSpace(int len) {
        if (this.elastic && this.buffer.capacity() - this.buffer.position() < len) {
            ByteBuffer newBuffer = ByteBuffer.allocate(Math.max(this.buffer.capacity() * 2, this.buffer.position() + len));
            this.buffer.limit(this.buffer.position());
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public void setElastic(boolean elastic) {
        this.elastic = elastic;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.needSpace(len);
        this.buffer.put(b, off, len);
    }

    @Override
    public void write(int b) {
        this.needSpace(1);
        this.buffer.put((byte)b);
    }
}

