/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int remaining = this.buffer.remaining();
        if (remaining > 0) {
            int readBytes = Math.min(remaining, len);
            this.buffer.get(b, off, readBytes);
            return readBytes;
        }
        return -1;
    }

    @Override
    public synchronized void reset() {
        this.buffer.reset();
    }

    @Override
    public long skip(long n) {
        int bytes = n > Integer.MAX_VALUE ? this.buffer.remaining() : Math.min(this.buffer.remaining(), (int)n);
        this.buffer.position(this.buffer.position() + bytes);
        return bytes;
    }
}

