/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;

public class FtpWagon
extends StreamWagon {
    private FTPClient ftp;

    public void openConnection() throws ConnectionException, AuthenticationException {
        AuthenticationInfo authInfo = this.getAuthenticationInfo();
        if (authInfo == null) {
            throw new IllegalArgumentException("Authentication Credentials cannot be null for FTP protocol");
        }
        if (authInfo.getUserName() == null) {
            authInfo.setUserName(System.getProperty("user.name"));
        }
        String username = authInfo.getUserName();
        String password = authInfo.getPassword();
        String host = this.getRepository().getHost();
        this.ftp = new FTPClient();
        this.ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(this));
        try {
            if (this.getRepository().getPort() != -1) {
                this.ftp.connect(host, this.getRepository().getPort());
            } else {
                this.ftp.connect(host);
            }
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.fireSessionConnectionRefused();
                this.fireSessionDisconnecting();
                this.ftp.disconnect();
                this.fireSessionDisconnected();
                throw new AuthenticationException("FTP server refused connection.");
            }
        }
        catch (IOException e) {
            if (this.ftp.isConnected()) {
                try {
                    this.fireSessionError(e);
                    this.fireSessionDisconnecting();
                    this.ftp.disconnect();
                    this.fireSessionDisconnected();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw new AuthenticationException("Could not connect to server.", (Throwable)e);
        }
        try {
            if (!this.ftp.login(username.trim(), password.trim())) {
                this.fireSessionConnectionRefused();
                throw new AuthenticationException("Cannot login to remote system");
            }
            this.fireSessionDebug("Remote system is " + this.ftp.getSystemName());
            this.ftp.setFileType(2);
            this.ftp.enterLocalPassiveMode();
        }
        catch (IOException e) {
            throw new ConnectionException("Cannot login to remote system", (Throwable)e);
        }
    }

    protected void firePutCompleted(Resource resource, File file) {
        try {
            this.ftp.completePendingCommand();
            RepositoryPermissions permissions = ((AbstractWagon)this).repository.getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.ftp.sendSiteCommand("CHGRP " + permissions.getGroup());
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.ftp.sendSiteCommand("CHMOD " + permissions.getFileMode());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.firePutCompleted(resource, file);
    }

    protected void fireGetCompleted(Resource resource, File localFile) {
        try {
            this.ftp.completePendingCommand();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.fireGetCompleted(resource, localFile);
    }

    public void closeConnection() throws ConnectionException {
        if (this.ftp != null && this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException e) {
                throw new ConnectionException("Failed to close connection to FTP repository", (Throwable)e);
            }
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        OutputStream os;
        Resource resource = outputData.getResource();
        RepositoryPermissions permissions = ((AbstractWagon)this).repository.getPermissions();
        try {
            if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
                throw new TransferFailedException("Required directory: '" + this.getRepository().getBasedir() + "' " + "is missing");
            }
            String[] dirs = PathUtils.dirnames((String)resource.getName());
            for (int i = 0; i < dirs.length; ++i) {
                boolean success;
                boolean dirChanged = this.ftp.changeWorkingDirectory(dirs[i]);
                if (!dirChanged && (success = this.ftp.makeDirectory(dirs[i]))) {
                    if (permissions != null && permissions.getGroup() != null) {
                        this.ftp.sendSiteCommand("CHGRP " + permissions.getGroup());
                    }
                    if (permissions != null && permissions.getDirectoryMode() != null) {
                        this.ftp.sendSiteCommand("CHMOD " + permissions.getDirectoryMode());
                    }
                    dirChanged = this.ftp.changeWorkingDirectory(dirs[i]);
                }
                if (dirChanged) continue;
                throw new TransferFailedException("Unable to create directory " + dirs[i]);
            }
            if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
                throw new TransferFailedException("Unable to return to the base directory");
            }
            os = this.ftp.storeFileStream(resource.getName());
            if (os == null) {
                String msg = "Cannot transfer resource:  '" + resource + "' Output stream is null. FTP Server response: " + this.ftp.getReplyString();
                throw new TransferFailedException(msg);
            }
            this.fireTransferDebug("resource = " + resource);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring over FTP", (Throwable)e);
        }
        outputData.setOutputStream(os);
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        InputStream is;
        Resource resource = inputData.getResource();
        try {
            this.ftpChangeDirectory(resource);
            String filename = PathUtils.filename((String)resource.getName());
            FTPFile[] ftpFiles = this.ftp.listFiles(filename);
            if (ftpFiles == null || ftpFiles.length <= 0) {
                throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
            }
            long contentLength = ftpFiles[0].getSize();
            long lastModified = ftpFiles[0].getTimestamp().getTimeInMillis();
            resource.setContentLength(contentLength);
            resource.setLastModified(lastModified);
            is = this.ftp.retrieveFileStream(filename);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file via FTP", (Throwable)e);
        }
        inputData.setInputStream(is);
    }

    private void ftpChangeDirectory(Resource resource) throws IOException, TransferFailedException, ResourceDoesNotExistException {
        if (!this.ftp.changeWorkingDirectory(this.getRepository().getBasedir())) {
            throw new TransferFailedException("Required directory: '" + this.getRepository().getBasedir() + "' " + "is missing");
        }
        String[] dirs = PathUtils.dirnames((String)resource.getName());
        for (int i = 0; i < dirs.length; ++i) {
            boolean dirChanged = this.ftp.changeWorkingDirectory(dirs[i]);
            if (dirChanged) continue;
            String msg = "Resource " + resource + " not found. Directory " + dirs[i] + " does not exist";
            throw new ResourceDoesNotExistException(msg);
        }
    }

    protected void fireSessionDebug(String msg) {
        super.fireSessionDebug(msg);
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destinationDirectory);
        try {
            this.ftpChangeDirectory(resource);
            String filename = PathUtils.filename((String)resource.getName());
            FTPFile[] ftpFiles = this.ftp.listFiles(filename);
            if (ftpFiles == null || ftpFiles.length <= 0) {
                throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < ftpFiles.length; ++i) {
                ret.add(ftpFiles[i].getName());
            }
            return ret;
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file via FTP", (Throwable)e);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        try {
            this.ftpChangeDirectory(resource);
            String filename = PathUtils.filename((String)resource.getName());
            int status = this.ftp.stat(filename);
            return status == 213 || status == 150 || status == 211;
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file via FTP", (Throwable)e);
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
    }

    public class PrintCommandListener
    implements ProtocolCommandListener {
        FtpWagon wagon;

        public PrintCommandListener(FtpWagon wagon) {
            this.wagon = wagon;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            this.wagon.fireSessionDebug("Command sent: " + event.getMessage());
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.wagon.fireSessionDebug("Reply received: " + event.getMessage());
        }
    }
}

