/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.Stoppable;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.internal.ConcurrencyUtils;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testng.utils.FailFastEventsSingleton;
import org.apache.maven.surefire.testng.utils.FailFastListener;
import org.apache.maven.surefire.testng.utils.FailFastNotifier;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

final class TestNGExecutor {
    private static final String DEFAULT_SUREFIRE_SUITE_NAME = "Surefire suite";
    private static final String DEFAULT_SUREFIRE_TEST_NAME = "Surefire test";
    private static final boolean HAS_TEST_ANNOTATION_ON_CLASSPATH = ReflectionUtils.tryLoadClass((ClassLoader)TestNGExecutor.class.getClassLoader(), (String)"org.testng.annotations.Test") != null;
    private static final Method XML_CLASS_SET_INDEX = ReflectionUtils.tryGetMethod(XmlClass.class, (String)"setIndex", (Class[])new Class[]{Integer.TYPE});
    private static final Constructor<XmlClass> XML_CLASS_CONSTRUCTOR_WITH_INDEX = ReflectionUtils.tryGetConstructor(XmlClass.class, (Class[])new Class[]{String.class, Boolean.TYPE, Integer.TYPE});

    private TestNGExecutor() {
        throw new IllegalStateException("not instantiable constructor");
    }

    static void run(Iterable<Class<?>> testClasses, String testSourceDirectory, Map<String, String> options, TestNGReporter testNGReporter, File reportsDirectory, TestListResolver methodFilter, List<CommandLineOption> mainCliOptions, int skipAfterFailureCount) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(options.get("testng.configurator"));
        if (TestNGExecutor.isCliDebugOrShowErrors(mainCliOptions)) {
            System.out.println("Configuring TestNG with: " + configurator.getClass().getSimpleName());
        }
        XmlMethodSelector groupMatchingSelector = TestNGExecutor.createGroupMatchingSelector(options);
        XmlMethodSelector methodNameFilteringSelector = TestNGExecutor.createMethodNameFilteringSelector(methodFilter);
        HashMap<String, SuiteAndNamedTests> suitesNames = new HashMap<String, SuiteAndNamedTests>();
        ArrayList<XmlSuite> xmlSuites = new ArrayList<XmlSuite>();
        for (Class<?> testClass : testClasses) {
            XmlTest xmlTest;
            TestMetadata metadata = TestNGExecutor.findTestMetadata(testClass);
            SuiteAndNamedTests suiteAndNamedTests = (SuiteAndNamedTests)suitesNames.get(metadata.suiteName);
            if (suiteAndNamedTests == null) {
                suiteAndNamedTests = new SuiteAndNamedTests();
                suiteAndNamedTests.xmlSuite.setName(metadata.suiteName);
                configurator.configure(suiteAndNamedTests.xmlSuite, options);
                xmlSuites.add(suiteAndNamedTests.xmlSuite);
                suitesNames.put(metadata.suiteName, suiteAndNamedTests);
            }
            if ((xmlTest = (XmlTest)suiteAndNamedTests.testNameToTest.get(metadata.testName)) == null) {
                xmlTest = new XmlTest(suiteAndNamedTests.xmlSuite);
                xmlTest.setName(metadata.testName);
                TestNGExecutor.addSelector(xmlTest, groupMatchingSelector);
                TestNGExecutor.addSelector(xmlTest, methodNameFilteringSelector);
                xmlTest.setXmlClasses(new ArrayList());
                suiteAndNamedTests.testNameToTest.put(metadata.testName, xmlTest);
            }
            xmlTest.getXmlClasses().add(TestNGExecutor.newXmlClassInstance(testClass.getName(), xmlTest.getXmlClasses().size()));
        }
        testng.setXmlSuites(xmlSuites);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, testNGReporter, reportsDirectory, skipAfterFailureCount, TestNGExecutor.extractVerboseLevel(options));
        testng.run();
    }

    private static XmlClass newXmlClassInstance(String testClassName, int index) {
        if (XML_CLASS_SET_INDEX != null) {
            XmlClass xmlClass = new XmlClass(testClassName);
            ReflectionUtils.invokeSetter((Object)xmlClass, (Method)XML_CLASS_SET_INDEX, (Object)index);
            return xmlClass;
        }
        if (XML_CLASS_CONSTRUCTOR_WITH_INDEX != null) {
            boolean loadClass = true;
            return (XmlClass)ReflectionUtils.newInstance(XML_CLASS_CONSTRUCTOR_WITH_INDEX, (Object[])new Object[]{testClassName, loadClass, index});
        }
        return new XmlClass(testClassName);
    }

    private static boolean isCliDebugOrShowErrors(List<CommandLineOption> mainCliOptions) {
        return mainCliOptions.contains(CommandLineOption.LOGGING_LEVEL_DEBUG) || mainCliOptions.contains(CommandLineOption.SHOW_ERRORS);
    }

    private static TestMetadata findTestMetadata(Class<?> testClass) {
        Test testAnnotation;
        TestMetadata result = new TestMetadata();
        if (HAS_TEST_ANNOTATION_ON_CLASSPATH && null != (testAnnotation = TestNGExecutor.findAnnotation(testClass, Test.class))) {
            if (!StringUtils.isBlank((String)testAnnotation.suiteName())) {
                result.suiteName = testAnnotation.suiteName();
            }
            if (!StringUtils.isBlank((String)testAnnotation.testName())) {
                result.testName = testAnnotation.testName();
            }
        }
        return result;
    }

    private static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationType) {
        if (clazz == null) {
            return null;
        }
        T result = clazz.getAnnotation(annotationType);
        if (result != null) {
            return result;
        }
        return TestNGExecutor.findAnnotation(clazz.getSuperclass(), annotationType);
    }

    private static void addSelector(XmlTest xmlTest, XmlMethodSelector selector) {
        if (selector != null) {
            xmlTest.getMethodSelectors().add(selector);
        }
    }

    private static XmlMethodSelector createMethodNameFilteringSelector(TestListResolver methodFilter) throws TestSetFailedException {
        if (methodFilter != null && !methodFilter.isEmpty()) {
            String clazzName = "org.apache.maven.surefire.testng.utils.MethodSelector";
            try {
                Class<?> clazz = Class.forName(clazzName);
                Method method = clazz.getMethod("setTestListResolver", TestListResolver.class);
                method.invoke(null, methodFilter);
            }
            catch (Exception e) {
                throw new TestSetFailedException(e.getMessage(), (Throwable)e);
            }
            XmlMethodSelector xms = new XmlMethodSelector();
            xms.setName(clazzName);
            xms.setPriority(10000);
            return xms;
        }
        return null;
    }

    private static XmlMethodSelector createGroupMatchingSelector(Map<String, String> options) throws TestSetFailedException {
        String groups = options.get("groups");
        String excludedGroups = options.get("excludegroups");
        if (groups == null && excludedGroups == null) {
            return null;
        }
        String clazzName = "org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector";
        try {
            Class<?> clazz = Class.forName("org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector");
            Method method = clazz.getMethod("setGroups", String.class, String.class);
            method.invoke(null, groups, excludedGroups);
        }
        catch (Exception e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        XmlMethodSelector xms = new XmlMethodSelector();
        xms.setName("org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector");
        xms.setPriority(9999);
        return xms;
    }

    static void run(List<String> suiteFiles, String testSourceDirectory, Map<String, String> options, TestNGReporter testNGReporter, File reportsDirectory, int skipAfterFailureCount) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(options.get("testng.configurator"));
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, testNGReporter, reportsDirectory, skipAfterFailureCount, TestNGExecutor.extractVerboseLevel(options));
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(String className) {
        try {
            return (Configurator)Class.forName(className).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, TestNGReporter testNGReporter, File reportsDirectory, int skipAfterFailureCount, int verboseLevel) {
        testNG.setVerbose(verboseLevel);
        testNG.addListener((Object)testNGReporter);
        if (skipAfterFailureCount > 0) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            testNG.addListener(ReflectionUtils.instantiate((ClassLoader)classLoader, (String)FailFastNotifier.class.getName(), Object.class));
            testNG.addListener((ITestListener)new FailFastListener(TestNGExecutor.createStoppable(testNGReporter.getRunListener(), skipAfterFailureCount)));
        }
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static Stoppable createStoppable(RunListener reportManager, int skipAfterFailureCount) {
        AtomicInteger currentFaultCount = new AtomicInteger(skipAfterFailureCount);
        return () -> {
            ConcurrencyUtils.runIfZeroCountDown(() -> FailFastEventsSingleton.getInstance().setSkipOnNextTest(), (AtomicInteger)currentFaultCount);
            reportManager.testExecutionSkippedByUser();
        };
    }

    private static int extractVerboseLevel(Map<String, String> options) throws TestSetFailedException {
        try {
            String verbose = options.get("surefire.testng.verbose");
            return verbose == null ? 0 : Integer.parseInt(verbose);
        }
        catch (NumberFormatException e) {
            throw new TestSetFailedException("Provider property 'surefire.testng.verbose' should refer to number -1 (debug mode), 0, 1 .. 10 (most detailed).", (Throwable)e);
        }
    }

    private static class TestMetadata {
        private String testName = "Surefire test";
        private String suiteName = "Surefire suite";

        private TestMetadata() {
        }
    }

    private static class SuiteAndNamedTests {
        private final XmlSuite xmlSuite = new XmlSuite();
        private final Map<String, XmlTest> testNameToTest = new HashMap<String, XmlTest>();

        private SuiteAndNamedTests() {
        }
    }
}

