/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.suite.AbstractDirectoryTestSuite;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testng.SynchronizedReporterManager;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNGTestSet;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;

public class TestNGDirectoryTestSuite
extends AbstractDirectoryTestSuite {
    private ArtifactVersion version;
    private String classifier;
    private Map options;
    private String testSourceDirectory;
    private File reportsDirectory;

    public TestNGDirectoryTestSuite(File basedir, ArrayList includes, ArrayList excludes, String testSourceDirectory, String artifactVersion, String artifactClassifier, Properties confOptions, File reportsDirectory) {
        this(basedir, (List)includes, (List)excludes, testSourceDirectory, (ArtifactVersion)new DefaultArtifactVersion(artifactVersion), artifactClassifier, (Map)confOptions, reportsDirectory);
    }

    public TestNGDirectoryTestSuite(File basedir, List includes, List excludes, String testSourceDirectory, ArtifactVersion artifactVersion, String artifactClassifier, Map confOptions, File reportsDirectory) {
        super(basedir, includes, excludes);
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.version = artifactVersion;
        this.classifier = artifactClassifier;
    }

    protected SurefireTestSet createTestSet(Class testClass, ClassLoader classLoader) {
        return new TestNGTestSet(testClass);
    }

    public void execute(TestsToRun testsToRun, ReporterFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = (ReporterManager)reporterManagerFactory.createReporter();
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, (Object)this);
        if (testsToRun.size() == 0) {
            return;
        }
        if (testsToRun.size() > 1) {
            this.executeMulti(testsToRun, reporterManagerFactory);
            return;
        }
        TestNGExecutor.run(new Class[]{(Class)testsToRun.iterator().next()}, this.testSourceDirectory, this.options, this.version, this.classifier, reporterManager, (SurefireTestSuite)this, this.reportsDirectory);
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, (Object)this);
    }

    public void executeMulti(TestsToRun testsToRun, ReporterFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        Class<?> junitTest;
        try {
            junitTest = Class.forName("junit.framework.Test");
        }
        catch (ClassNotFoundException e) {
            junitTest = null;
        }
        ArrayList<Class> testNgTestClasses = new ArrayList<Class>();
        ArrayList<Class> junitTestClasses = new ArrayList<Class>();
        Iterator it = testsToRun.iterator();
        while (it.hasNext()) {
            Class testSet;
            Class c = testSet = (Class)it.next();
            if (junitTest != null && junitTest.isAssignableFrom(c)) {
                junitTestClasses.add(c);
                continue;
            }
            testNgTestClasses.add(c);
        }
        File testNgReportsDirectory = this.reportsDirectory;
        File junitReportsDirectory = this.reportsDirectory;
        if (junitTestClasses.size() > 0 && testNgTestClasses.size() > 0) {
            testNgReportsDirectory = new File(this.reportsDirectory, "testng-native-results");
            junitReportsDirectory = new File(this.reportsDirectory, "testng-junit-results");
        }
        SynchronizedReporterManager reporterManager = new SynchronizedReporterManager((ReporterManager)reporterManagerFactory.createReporter());
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, (Object)this);
        Class[] testClasses = testNgTestClasses.toArray(new Class[0]);
        TestNGExecutor.run(testClasses, this.testSourceDirectory, this.options, this.version, this.classifier, (ReporterManager)reporterManager, (SurefireTestSuite)this, testNgReportsDirectory);
        if (junitTestClasses.size() > 0) {
            testClasses = junitTestClasses.toArray(new Class[0]);
            HashMap junitOptions = new HashMap();
            Iterator it2 = this.options.keySet().iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                junitOptions.put(key, this.options.get(key));
            }
            junitOptions.put("junit", Boolean.TRUE);
            TestNGExecutor.run(testClasses, this.testSourceDirectory, junitOptions, this.version, this.classifier, (ReporterManager)reporterManager, (SurefireTestSuite)this, junitReportsDirectory);
        }
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, (Object)this);
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SurefireTestSet testSet = (SurefireTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        ReporterManager reporterManager = reporterManagerFactory.createReporterManager();
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, (Object)this);
        TestNGExecutor.run(new Class[]{testSet.getTestClass()}, this.testSourceDirectory, this.options, this.version, this.classifier, reporterManager, (SurefireTestSuite)this, this.reportsDirectory);
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, (Object)this);
    }

    public void execute(ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        Class<?> junitTest;
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        try {
            junitTest = Class.forName("junit.framework.Test");
        }
        catch (ClassNotFoundException e) {
            junitTest = null;
        }
        ArrayList<Class> testNgTestClasses = new ArrayList<Class>();
        ArrayList<Class> junitTestClasses = new ArrayList<Class>();
        Iterator it = this.testSets.values().iterator();
        while (it.hasNext()) {
            SurefireTestSet testSet = (SurefireTestSet)it.next();
            Class c = testSet.getTestClass();
            if (junitTest != null && junitTest.isAssignableFrom(c)) {
                junitTestClasses.add(c);
                continue;
            }
            testNgTestClasses.add(c);
        }
        File testNgReportsDirectory = this.reportsDirectory;
        File junitReportsDirectory = this.reportsDirectory;
        if (junitTestClasses.size() > 0 && testNgTestClasses.size() > 0) {
            testNgReportsDirectory = new File(this.reportsDirectory, "testng-native-results");
            junitReportsDirectory = new File(this.reportsDirectory, "testng-junit-results");
        }
        SynchronizedReporterManager reporterManager = new SynchronizedReporterManager(reporterManagerFactory.createReporterManager());
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, (Object)this);
        Class[] testClasses = testNgTestClasses.toArray(new Class[0]);
        TestNGExecutor.run(testClasses, this.testSourceDirectory, this.options, this.version, this.classifier, (ReporterManager)reporterManager, (SurefireTestSuite)this, testNgReportsDirectory);
        if (junitTestClasses.size() > 0) {
            testClasses = junitTestClasses.toArray(new Class[0]);
            HashMap junitOptions = new HashMap();
            Iterator it2 = this.options.keySet().iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                junitOptions.put(key, this.options.get(key));
            }
            junitOptions.put("junit", Boolean.TRUE);
            TestNGExecutor.run(testClasses, this.testSourceDirectory, junitOptions, this.version, this.classifier, (ReporterManager)reporterManager, (SurefireTestSuite)this, junitReportsDirectory);
        }
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, (Object)this);
    }

    public static void startTestSuite(ReporterManager reporterManager, Object suite) {
        String rawString = bundle.getString("testSetStarting");
        DefaultReportEntry report = new DefaultReportEntry(suite.getClass().getName(), TestNGDirectoryTestSuite.getSuiteName(suite), rawString);
        try {
            reporterManager.testSetStarting((ReportEntry)report);
        }
        catch (ReporterException e) {
            // empty catch block
        }
    }

    public static void finishTestSuite(ReporterManager reporterManager, Object suite) {
        String rawString = bundle.getString("testSetCompletedNormally");
        DefaultReportEntry report = new DefaultReportEntry(suite.getClass().getName(), TestNGDirectoryTestSuite.getSuiteName(suite), rawString);
        reporterManager.testSetCompleted((ReportEntry)report);
        reporterManager.reset();
    }

    public String getSuiteName() {
        String result = (String)this.options.get("suitename");
        if (result == null) {
            result = "TestSuite";
        }
        return result;
    }

    private static String getSuiteName(Object suite) {
        if (suite instanceof TestNGDirectoryTestSuite) {
            return ((TestNGDirectoryTestSuite)((Object)suite)).getSuiteName();
        }
        if (suite instanceof TestNGXmlTestSuite) {
            return ((TestNGXmlTestSuite)suite).getSuiteName();
        }
        String result = "TestSuite";
        return result;
    }
}

