/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.testng.TestNG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGExecutor {
    private TestNGExecutor() {
    }

    public static void run(Class[] testClasses, String testSourceDirectory, Map options, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory, String methodNamePattern) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        TestNGExecutor.applyGroupMatching(testng, options);
        if (!StringUtils.isBlank((String)methodNamePattern)) {
            TestNGExecutor.applyMethodNameFiltering(testng, methodNamePattern);
        }
        Configurator configurator = TestNGExecutor.getConfigurator((String)options.get("testng.configurator"));
        System.out.println("Configuring TestNG with: " + configurator.getClass().getSimpleName());
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, suite, reportsDirectory);
        testng.setTestClasses(testClasses);
        testng.run();
    }

    private static void applyMethodNameFiltering(TestNG testng, String methodNamePattern) throws TestSetFailedException {
        String clazzName = "org.apache.maven.surefire.testng.utils.MethodSelector";
        testng.addMethodSelector(clazzName, 10000);
        try {
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("setMethodName", String.class);
            method.invoke(null, methodNamePattern);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private static void applyGroupMatching(TestNG testng, Map options) throws TestSetFailedException {
        String groups = (String)options.get("groups");
        String excludedGroups = (String)options.get("excludegroups");
        if (groups == null && excludedGroups == null) {
            return;
        }
        String clazzName = "org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector";
        testng.addMethodSelector(clazzName, 9999);
        try {
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("setGroups", String.class, String.class);
            method.invoke(null, groups, excludedGroups);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public static void run(List<String> suiteFiles, String testSourceDirectory, Map options, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator((String)options.get("testng.configurator"));
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, suite, reportsDirectory);
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(String className) {
        try {
            return (Configurator)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        testNG.setVerbose(0);
        TestNGReporter reporter = TestNGExecutor.createTestNGReporter(reportManager, suite);
        testNG.addListener((Object)reporter);
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static TestNGReporter createTestNGReporter(RunListener reportManager, TestNgTestSuite suite) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            try {
                Constructor<?> ctor = c.getConstructor(RunListener.class, TestNgTestSuite.class);
                return (TestNGReporter)ctor.newInstance(reportManager, suite);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Bug in ConfigurationAwareTestNGReporter", (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
    }
}

