/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shared.io.channels;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.channels.Channel;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.surefire.shared.io.channels.CloseShieldChannelHandler;

public final class CloseShieldChannel {
    private static final Class<?>[] EMPTY = new Class[0];

    private static Set<Class<?>> collectChannelInterfaces(Class<?> type, Set<Class<?>> out) {
        for (Class<?> currentType = type; currentType != null; currentType = currentType.getSuperclass()) {
            for (Class<?> iface : currentType.getInterfaces()) {
                if (!CloseShieldChannelHandler.isSupported(iface) || !out.add(iface)) continue;
                CloseShieldChannel.collectChannelInterfaces(iface, out);
            }
        }
        return out;
    }

    public static <T extends Channel> T wrap(T channel) {
        Class[] classArray;
        Objects.requireNonNull(channel, "channel");
        if (Proxy.isProxyClass(channel.getClass()) && Proxy.getInvocationHandler(channel) instanceof CloseShieldChannelHandler) {
            return channel;
        }
        Set<Class<?>> set = CloseShieldChannel.collectChannelInterfaces(channel.getClass(), new LinkedHashSet());
        ClassLoader classLoader = channel.getClass().getClassLoader();
        if (set.isEmpty()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Channel.class;
        } else {
            classArray = set.toArray(EMPTY);
        }
        return (T)((Channel)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new CloseShieldChannelHandler(channel)));
    }

    private CloseShieldChannel() {
    }
}

