/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.api.report.OutputReportEntry;
import org.apache.maven.shadefire.surefire.api.report.TestOutputReceiver;
import org.apache.maven.shadefire.surefire.api.report.TestOutputReportEntry;

public final class ConsoleOutputCapture {
    public static void startCapture(TestOutputReceiver<OutputReportEntry> target) {
        System.setOut(new ForwardingPrintStream(true, target));
        System.setErr(new ForwardingPrintStream(false, target));
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }
    }

    private static final class ForwardingPrintStream
    extends PrintStream {
        private final boolean isStdout;
        private final TestOutputReceiver<OutputReportEntry> target;

        ForwardingPrintStream(boolean stdout, TestOutputReceiver<OutputReportEntry> target) {
            super(new NullOutputStream());
            this.isStdout = stdout;
            this.target = target;
        }

        @Override
        public void write(@Nonnull byte[] buf, int off, int len) {
            String log = new String(buf, off, len);
            this.target.writeTestOutput(this.isStdout ? TestOutputReportEntry.stdOut(log) : TestOutputReportEntry.stdErr(log));
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) {
            try {
                this.write(new byte[]{(byte)b});
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void println(boolean x) {
            this.println(x ? "true" : "false");
        }

        @Override
        public void println(char x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(int x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(long x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(float x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(double x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(@Nonnull char[] x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(Object x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(String s) {
            String log = s == null ? "null" : s;
            this.target.writeTestOutput(this.isStdout ? TestOutputReportEntry.stdOutln(log) : TestOutputReportEntry.stdErrln(log));
        }

        @Override
        public void println() {
            this.target.writeTestOutput(this.isStdout ? TestOutputReportEntry.stdOutln("") : TestOutputReportEntry.stdErrln(""));
        }

        @Override
        public void print(boolean x) {
            this.print(x ? "true" : "false");
        }

        @Override
        public void print(char x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(int x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(long x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(float x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(double x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(@Nonnull char[] x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(Object x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(String s) {
            String log = s == null ? "null" : s;
            this.target.writeTestOutput(this.isStdout ? TestOutputReportEntry.stdOut(log) : TestOutputReportEntry.stdErr(log));
        }

        @Override
        public PrintStream append(CharSequence csq) {
            this.print(csq == null ? "null" : csq.toString());
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            CharSequence s = csq == null ? "null" : csq;
            this.print(s.subSequence(start, end).toString());
            return this;
        }

        @Override
        public PrintStream append(char c) {
            this.print(c);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

