/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.report;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.shadefire.surefire.api.util.internal.ClassMethod;

public final class ClassMethodIndexer {
    private final AtomicInteger classIndex = new AtomicInteger(1);
    private final AtomicInteger methodIndex = new AtomicInteger(1);
    private final Map<ClassMethod, Long> testIdMapping = new ConcurrentHashMap<ClassMethod, Long>();
    private final ThreadLocal<Long> testLocalMapping = new ThreadLocal();

    public long indexClassMethod(String clazz, String method) {
        ClassMethod key = new ClassMethod(Objects.requireNonNull(clazz), method);
        return this.testIdMapping.computeIfAbsent(key, cm -> {
            Long classId = this.testIdMapping.get(new ClassMethod(Objects.requireNonNull(clazz), null));
            long c = classId == null ? (long)this.classIndex.getAndIncrement() << 32 : classId;
            int m = method == null ? 0 : this.methodIndex.getAndIncrement();
            long id = c | (long)m;
            this.testLocalMapping.set(id);
            return id;
        });
    }

    public long indexClass(String clazz) {
        return this.indexClassMethod(clazz, null);
    }

    public Long getLocalIndex() {
        return this.testLocalMapping.get();
    }
}

