/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.shadefire.surefire.api.report.SafeThrowable;
import org.apache.maven.shadefire.surefire.api.report.StackTraceWriter;
import org.apache.maven.shadefire.surefire.shared.utils.StringUtils;

public class LegacyPojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    private final String testClass;
    private final String testMethod;

    public LegacyPojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    @Override
    public String writeTraceToString() {
        if (this.t != null) {
            String exc;
            StringWriter w = new StringWriter();
            try (PrintWriter stackTrace = new PrintWriter(w);){
                this.t.printStackTrace(stackTrace);
            }
            StringBuffer builder = w.getBuffer();
            if (LegacyPojoStackTraceWriter.isMultiLineExceptionMessage(this.t) && org.apache.maven.shadefire.surefire.api.util.internal.StringUtils.startsWith(builder, exc = this.t.getClass().getName() + ": ")) {
                builder.insert(exc.length(), '\n');
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public String smartTrimmedStackTrace() {
        StringBuilder result = new StringBuilder();
        result.append(this.testClass);
        result.append("#");
        result.append(this.testMethod);
        SafeThrowable throwable = this.getThrowable();
        Throwable target = throwable.getTarget();
        if (target != null) {
            String msg;
            if (!(target instanceof AssertionError)) {
                result.append(' ').append(target.getClass().getSimpleName());
            }
            if (StringUtils.isNotEmpty(msg = throwable.getMessage())) {
                result.append(' ').append(msg);
            }
        }
        return result.toString();
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }

    @Override
    public String writeTrimmedTraceToString() {
        int i;
        String text = this.writeTraceToString();
        String marker = "at " + this.testClass + "." + this.testMethod;
        String[] lines = org.apache.maven.shadefire.surefire.api.util.internal.StringUtils.split(text, "\n");
        int lastLine = lines.length - 1;
        int causedByLine = -1;
        for (int i2 = 1; i2 < lines.length; ++i2) {
            String line = lines[i2].trim();
            if (line.startsWith(marker)) {
                lastLine = i2;
                continue;
            }
            if (!line.startsWith("Caused by")) continue;
            causedByLine = i2;
            break;
        }
        StringBuilder trace = new StringBuilder();
        for (i = 0; i <= lastLine; ++i) {
            trace.append(lines[i]);
            trace.append("\n");
        }
        if (causedByLine != -1) {
            for (i = causedByLine; i < lines.length; ++i) {
                trace.append(lines[i]);
                trace.append("\n");
            }
        }
        return trace.toString();
    }

    @Override
    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.t);
    }
}

