/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ModularClasspath {
    private final String moduleNameFromDescriptor;
    private final List<String> modulePath;
    private final Collection<String> packages;
    private final File patchFile;
    private final boolean isMainDescriptor;

    public ModularClasspath(@Nonnull String moduleNameFromDescriptor, @Nonnull List<String> modulePath, @Nonnull Collection<String> packages, File patchFile, boolean isMainDescriptor) {
        this.moduleNameFromDescriptor = moduleNameFromDescriptor;
        this.modulePath = modulePath;
        this.packages = packages;
        this.patchFile = isMainDescriptor ? Objects.requireNonNull(patchFile, "patchFile should not be null") : patchFile;
        this.isMainDescriptor = isMainDescriptor;
    }

    @Nonnull
    public String getModuleNameFromDescriptor() {
        return this.moduleNameFromDescriptor;
    }

    @Nonnull
    public List<String> getModulePath() {
        return Collections.unmodifiableList(this.modulePath);
    }

    @Nonnull
    public Collection<String> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    public File getPatchFile() {
        return this.patchFile;
    }

    public boolean isMainDescriptor() {
        return this.isMainDescriptor;
    }
}

