/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.shadefire.plugin.surefire.log.api.ConsoleLoggerDecorator;
import org.apache.maven.shadefire.surefire.booter.BaseProviderFactory;
import org.apache.maven.shadefire.surefire.booter.DirectoryScannerParametersAware;
import org.apache.maven.shadefire.surefire.booter.MainCliOptionsAware;
import org.apache.maven.shadefire.surefire.booter.ProviderPropertiesAware;
import org.apache.maven.shadefire.surefire.booter.ReporterConfigurationAware;
import org.apache.maven.shadefire.surefire.booter.Shutdown;
import org.apache.maven.shadefire.surefire.booter.ShutdownAware;
import org.apache.maven.shadefire.surefire.booter.SurefireClassLoadersAware;
import org.apache.maven.shadefire.surefire.booter.TestArtifactInfoAware;
import org.apache.maven.shadefire.surefire.booter.TestRequestAware;
import org.apache.maven.shadefire.surefire.cli.CommandLineOption;
import org.apache.maven.shadefire.surefire.providerapi.ProviderParameters;
import org.apache.maven.shadefire.surefire.report.ReporterConfiguration;
import org.apache.maven.shadefire.surefire.report.ReporterFactory;
import org.apache.maven.shadefire.surefire.suite.RunResult;
import org.apache.maven.shadefire.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.shadefire.surefire.testset.RunOrderParameters;
import org.apache.maven.shadefire.surefire.testset.TestArtifactInfo;
import org.apache.maven.shadefire.surefire.testset.TestListResolver;
import org.apache.maven.shadefire.surefire.testset.TestRequest;
import org.apache.maven.shadefire.surefire.util.ReflectionUtils;
import org.apache.maven.shadefire.surefire.util.RunOrder;
import org.apache.maven.shadefire.surefire.util.SurefireReflectionException;

public class SurefireReflector {
    private final ClassLoader surefireClassLoader;
    private final Class<?> reporterConfiguration;
    private final Class<?> testRequest;
    private final Class<?> testArtifactInfo;
    private final Class<?> testArtifactInfoAware;
    private final Class<?> directoryScannerParameters;
    private final Class<?> runOrderParameters;
    private final Class<?> directoryScannerParametersAware;
    private final Class<?> testSuiteDefinitionAware;
    private final Class<?> testClassLoaderAware;
    private final Class<?> reporterConfigurationAware;
    private final Class<?> providerPropertiesAware;
    private final Class<?> runResult;
    private final Class<?> booterParameters;
    private final Class<?> reporterFactory;
    private final Class<?> testListResolver;
    private final Class<?> mainCliOptions;
    private final Class<Enum> commandLineOptionsClass;
    private final Class<?> shutdownAwareClass;
    private final Class<Enum> shutdownClass;

    public SurefireReflector(ClassLoader surefireClassLoader) {
        this.surefireClassLoader = surefireClassLoader;
        try {
            this.reporterConfiguration = surefireClassLoader.loadClass(ReporterConfiguration.class.getName());
            this.testRequest = surefireClassLoader.loadClass(TestRequest.class.getName());
            this.testArtifactInfo = surefireClassLoader.loadClass(TestArtifactInfo.class.getName());
            this.testArtifactInfoAware = surefireClassLoader.loadClass(TestArtifactInfoAware.class.getName());
            this.directoryScannerParameters = surefireClassLoader.loadClass(DirectoryScannerParameters.class.getName());
            this.runOrderParameters = surefireClassLoader.loadClass(RunOrderParameters.class.getName());
            this.directoryScannerParametersAware = surefireClassLoader.loadClass(DirectoryScannerParametersAware.class.getName());
            this.testSuiteDefinitionAware = surefireClassLoader.loadClass(TestRequestAware.class.getName());
            this.testClassLoaderAware = surefireClassLoader.loadClass(SurefireClassLoadersAware.class.getName());
            this.reporterConfigurationAware = surefireClassLoader.loadClass(ReporterConfigurationAware.class.getName());
            this.providerPropertiesAware = surefireClassLoader.loadClass(ProviderPropertiesAware.class.getName());
            this.reporterFactory = surefireClassLoader.loadClass(ReporterFactory.class.getName());
            this.runResult = surefireClassLoader.loadClass(RunResult.class.getName());
            this.booterParameters = surefireClassLoader.loadClass(ProviderParameters.class.getName());
            this.testListResolver = surefireClassLoader.loadClass(TestListResolver.class.getName());
            this.mainCliOptions = surefireClassLoader.loadClass(MainCliOptionsAware.class.getName());
            this.commandLineOptionsClass = surefireClassLoader.loadClass(CommandLineOption.class.getName());
            this.shutdownAwareClass = surefireClassLoader.loadClass(ShutdownAware.class.getName());
            this.shutdownClass = surefireClassLoader.loadClass(Shutdown.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public Object convertIfRunResult(Object result) {
        if (result == null || !this.isRunResult(result)) {
            return result;
        }
        int getCompletedCount1 = (Integer)ReflectionUtils.invokeGetter(result, "getCompletedCount");
        int getErrors = (Integer)ReflectionUtils.invokeGetter(result, "getErrors");
        int getSkipped = (Integer)ReflectionUtils.invokeGetter(result, "getSkipped");
        int getFailures = (Integer)ReflectionUtils.invokeGetter(result, "getFailures");
        return new RunResult(getCompletedCount1, getErrors, getFailures, getSkipped);
    }

    Object createTestRequest(TestRequest suiteDefinition) {
        if (suiteDefinition == null) {
            return null;
        }
        Object resolver = this.createTestListResolver(suiteDefinition.getTestListResolver());
        Class[] arguments = new Class[]{List.class, File.class, this.testListResolver, Integer.TYPE};
        Constructor constructor = ReflectionUtils.getConstructor(this.testRequest, arguments);
        return ReflectionUtils.newInstance(constructor, suiteDefinition.getSuiteXmlFiles(), suiteDefinition.getTestSourceDirectory(), resolver, suiteDefinition.getRerunFailingTestsCount());
    }

    Object createTestListResolver(TestListResolver resolver) {
        if (resolver == null) {
            return null;
        }
        Constructor constructor = ReflectionUtils.getConstructor(this.testListResolver, String.class);
        return ReflectionUtils.newInstance(constructor, resolver.getPluginParameterTest());
    }

    Object createDirectoryScannerParameters(DirectoryScannerParameters directoryScannerParameters) {
        if (directoryScannerParameters == null) {
            return null;
        }
        Class[] arguments = new Class[]{File.class, List.class, List.class, List.class, Boolean.TYPE, String.class};
        Constructor constructor = ReflectionUtils.getConstructor(this.directoryScannerParameters, arguments);
        return ReflectionUtils.newInstance(constructor, directoryScannerParameters.getTestClassesDirectory(), directoryScannerParameters.getIncludes(), directoryScannerParameters.getExcludes(), directoryScannerParameters.getSpecificTests(), directoryScannerParameters.isFailIfNoTests(), RunOrder.asString(directoryScannerParameters.getRunOrder()));
    }

    Object createRunOrderParameters(RunOrderParameters runOrderParameters) {
        if (runOrderParameters == null) {
            return null;
        }
        Class[] arguments = new Class[]{String.class, File.class};
        Constructor constructor = ReflectionUtils.getConstructor(this.runOrderParameters, arguments);
        File runStatisticsFile = runOrderParameters.getRunStatisticsFile();
        return ReflectionUtils.newInstance(constructor, RunOrder.asString(runOrderParameters.getRunOrder()), runStatisticsFile);
    }

    Object createTestArtifactInfo(TestArtifactInfo testArtifactInfo) {
        if (testArtifactInfo == null) {
            return null;
        }
        Class[] arguments = new Class[]{String.class, String.class};
        Constructor constructor = ReflectionUtils.getConstructor(this.testArtifactInfo, arguments);
        return ReflectionUtils.newInstance(constructor, testArtifactInfo.getVersion(), testArtifactInfo.getClassifier());
    }

    Object createReporterConfiguration(ReporterConfiguration reporterConfig) {
        Constructor constructor = ReflectionUtils.getConstructor(this.reporterConfiguration, File.class, Boolean.TYPE);
        return ReflectionUtils.newInstance(constructor, reporterConfig.getReportsDirectory(), reporterConfig.isTrimStackTrace());
    }

    public Object createBooterConfiguration(ClassLoader surefireClassLoader, Object factoryInstance, boolean insideFork) {
        return ReflectionUtils.instantiateTwoArgs(surefireClassLoader, BaseProviderFactory.class.getName(), this.reporterFactory, factoryInstance, Boolean.TYPE, insideFork);
    }

    public Object instantiateProvider(String providerClassName, Object booterParameters) {
        return ReflectionUtils.instantiateOneArg(this.surefireClassLoader, providerClassName, this.booterParameters, booterParameters);
    }

    public void setIfDirScannerAware(Object o, DirectoryScannerParameters dirScannerParams) {
        if (this.directoryScannerParametersAware.isAssignableFrom(o.getClass())) {
            this.setDirectoryScannerParameters(o, dirScannerParams);
        }
    }

    public void setMainCliOptions(Object o, List<CommandLineOption> options) {
        if (this.mainCliOptions.isAssignableFrom(o.getClass())) {
            List<Enum> newOptions = Collections.checkedList(new ArrayList(options.size()), this.commandLineOptionsClass);
            Collection<Integer> ordinals = SurefireReflector.toOrdinals(options);
            for (Enum e : this.commandLineOptionsClass.getEnumConstants()) {
                if (!ordinals.contains(e.ordinal())) continue;
                newOptions.add(e);
            }
            ReflectionUtils.invokeSetter(o, "setMainCliOptions", List.class, newOptions);
        }
    }

    public void setSkipAfterFailureCount(Object o, int skipAfterFailureCount) {
        ReflectionUtils.invokeSetter(o, "setSkipAfterFailureCount", Integer.TYPE, skipAfterFailureCount);
    }

    public void setShutdown(Object o, Shutdown shutdown) {
        if (this.shutdownAwareClass.isAssignableFrom(o.getClass())) {
            for (Enum e : this.shutdownClass.getEnumConstants()) {
                if (shutdown.ordinal() != e.ordinal()) continue;
                ReflectionUtils.invokeSetter(o, "setShutdown", this.shutdownClass, e);
                break;
            }
        }
    }

    public void setSystemExitTimeout(Object o, Integer systemExitTimeout) {
        ReflectionUtils.invokeSetter(o, "setSystemExitTimeout", Integer.class, systemExitTimeout);
    }

    public void setDirectoryScannerParameters(Object o, DirectoryScannerParameters dirScannerParams) {
        Object param = this.createDirectoryScannerParameters(dirScannerParams);
        ReflectionUtils.invokeSetter(o, "setDirectoryScannerParameters", this.directoryScannerParameters, param);
    }

    public void setRunOrderParameters(Object o, RunOrderParameters runOrderParameters) {
        Object param = this.createRunOrderParameters(runOrderParameters);
        ReflectionUtils.invokeSetter(o, "setRunOrderParameters", this.runOrderParameters, param);
    }

    public void setTestSuiteDefinitionAware(Object o, TestRequest testSuiteDefinition2) {
        if (this.testSuiteDefinitionAware.isAssignableFrom(o.getClass())) {
            this.setTestSuiteDefinition(o, testSuiteDefinition2);
        }
    }

    void setTestSuiteDefinition(Object o, TestRequest testSuiteDefinition1) {
        Object param = this.createTestRequest(testSuiteDefinition1);
        ReflectionUtils.invokeSetter(o, "setTestRequest", this.testRequest, param);
    }

    public void setProviderPropertiesAware(Object o, Map<String, String> properties) {
        if (this.providerPropertiesAware.isAssignableFrom(o.getClass())) {
            this.setProviderProperties(o, properties);
        }
    }

    void setProviderProperties(Object o, Map<String, String> providerProperties) {
        ReflectionUtils.invokeSetter(o, "setProviderProperties", Map.class, providerProperties);
    }

    public void setReporterConfigurationAware(Object o, ReporterConfiguration reporterConfiguration1) {
        if (this.reporterConfigurationAware.isAssignableFrom(o.getClass())) {
            this.setReporterConfiguration(o, reporterConfiguration1);
        }
    }

    void setReporterConfiguration(Object o, ReporterConfiguration reporterConfiguration) {
        Object param = this.createReporterConfiguration(reporterConfiguration);
        ReflectionUtils.invokeSetter(o, "setReporterConfiguration", this.reporterConfiguration, param);
    }

    public void setTestClassLoaderAware(Object o, ClassLoader testClassLoader) {
        if (this.testClassLoaderAware.isAssignableFrom(o.getClass())) {
            this.setTestClassLoader(o, testClassLoader);
        }
    }

    void setTestClassLoader(Object o, ClassLoader testClassLoader) {
        Method setter = ReflectionUtils.getMethod(o, "setClassLoaders", ClassLoader.class);
        ReflectionUtils.invokeMethodWithArray(o, setter, testClassLoader);
    }

    public void setTestArtifactInfoAware(Object o, TestArtifactInfo testArtifactInfo1) {
        if (this.testArtifactInfoAware.isAssignableFrom(o.getClass())) {
            this.setTestArtifactInfo(o, testArtifactInfo1);
        }
    }

    void setTestArtifactInfo(Object o, TestArtifactInfo testArtifactInfo) {
        Object param = this.createTestArtifactInfo(testArtifactInfo);
        ReflectionUtils.invokeSetter(o, "setTestArtifactInfo", this.testArtifactInfo, param);
    }

    private boolean isRunResult(Object o) {
        return this.runResult.isAssignableFrom(o.getClass());
    }

    public Object createConsoleLogger(@Nonnull ConsoleLogger consoleLogger) {
        return SurefireReflector.createConsoleLogger(consoleLogger, this.surefireClassLoader);
    }

    private static Collection<Integer> toOrdinals(Collection<? extends Enum> enums) {
        ArrayList<Integer> ordinals = new ArrayList<Integer>(enums.size());
        for (Enum enum_ : enums) {
            ordinals.add(enum_.ordinal());
        }
        return ordinals;
    }

    public static Object createConsoleLogger(ConsoleLogger consoleLogger, ClassLoader cl) {
        try {
            Class<?> decoratorClass = cl.loadClass(ConsoleLoggerDecorator.class.getName());
            return ReflectionUtils.getConstructor(decoratorClass, Object.class).newInstance(consoleLogger);
        }
        catch (Exception e) {
            throw new SurefireReflectionException(e);
        }
    }

    class ClassLoaderProxy
    implements InvocationHandler {
        private final Object target;

        ClassLoaderProxy(Object delegate) {
            this.target = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method delegateMethod = this.target.getClass().getMethod(method.getName(), method.getParameterTypes());
            return delegateMethod.invoke(this.target, args);
        }
    }
}

