/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import org.apache.maven.surefire.shadefire.booter.BooterDeserializer;
import org.apache.maven.surefire.shadefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.shadefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.shadefire.booter.ProviderFactory;
import org.apache.maven.surefire.shadefire.booter.StartupConfiguration;
import org.apache.maven.surefire.shadefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.shadefire.booter.SurefireReflector;
import org.apache.maven.surefire.shadefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.shadefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.shadefire.suite.RunResult;

public class ForkedBooter {
    private static final long SYSTEM_EXIT_TIMEOUT = 30000L;

    public static void main(String[] args) throws Throwable {
        PrintStream originalOut = System.out;
        try {
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration providerConfiguration = booterDeserializer.deserialize();
            StartupConfiguration startupConfiguration = booterDeserializer.getProviderConfiguration();
            TypeEncodedValue forkedTestSet = providerConfiguration.getTestForFork();
            ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
            ClassLoader testClassLoader = classpathConfiguration.createForkingTestClassLoader(startupConfiguration.isManifestOnlyJarRequestedAndUsable());
            startupConfiguration.writeSurefireTestClasspathProperty();
            Object testSet = forkedTestSet != null ? forkedTestSet.getDecodedValue(testClassLoader) : null;
            ForkedBooter.runSuitesInProcess(testSet, testClassLoader, startupConfiguration, providerConfiguration, originalOut);
            originalOut.println("Z,0,BYE!");
            originalOut.flush();
            ForkedBooter.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            ForkedBooter.exit(1);
        }
    }

    private static void exit(int returnCode) {
        ForkedBooter.launchLastDitchDaemonShutdownThread(returnCode);
        System.exit(returnCode);
    }

    private static RunResult runSuitesInProcess(Object testSet, ClassLoader testsClassLoader, StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) throws SurefireExecutionException {
        ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
        ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
        SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
        Object factory = ForkedBooter.createForkingReporterFactory(surefireReflector, providerConfiguration, originalSystemOut);
        return ProviderFactory.invokeProvider(testSet, testsClassLoader, surefireClassLoader, factory, providerConfiguration, true, startupConfiguration, false);
    }

    private static Object createForkingReporterFactory(SurefireReflector surefireReflector, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) {
        Boolean trimStackTrace = providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return surefireReflector.createForkingReporterFactory(trimStackTrace, originalSystemOut);
    }

    private static void launchLastDitchDaemonShutdownThread(final int returnCode) {
        Thread lastExit = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                    Runtime.getRuntime().halt(returnCode);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        lastExit.setDaemon(true);
        lastExit.start();
    }
}

