/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.booter;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.maven.surefire.shadefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.shadefire.booter.StartupConfiguration;
import org.apache.maven.surefire.shadefire.booter.SurefireReflector;
import org.apache.maven.surefire.shadefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.shadefire.report.ReporterException;
import org.apache.maven.surefire.shadefire.suite.RunResult;
import org.apache.maven.surefire.shadefire.testset.TestSetFailedException;
import org.apache.maven.surefire.shadefire.util.NestedRuntimeException;
import org.apache.maven.surefire.shadefire.util.ReflectionUtils;

public class ProviderFactory {
    private final StartupConfiguration startupConfiguration;
    private final ProviderConfiguration providerConfiguration;
    private final ClassLoader surefireClassLoader;
    private final ClassLoader testsClassLoader;
    private final SurefireReflector surefireReflector;
    private final Object reporterManagerFactory;
    private static final Class[] invokeParamaters = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ProviderFactory.class$("java.lang.Object")) : class$java$lang$Object};
    static /* synthetic */ Class class$java$lang$Object;

    public ProviderFactory(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Object reporterManagerFactory) {
        this.providerConfiguration = providerConfiguration;
        this.surefireClassLoader = surefireClassLoader;
        this.startupConfiguration = startupConfiguration;
        this.surefireReflector = new SurefireReflector(surefireClassLoader);
        this.testsClassLoader = testsClassLoader;
        this.reporterManagerFactory = reporterManagerFactory;
    }

    public static RunResult invokeProvider(Object testSet, ClassLoader testsClassLoader, ClassLoader surefireClassLoader, Object factory, ProviderConfiguration providerConfiguration, boolean insideFork, StartupConfiguration startupConfiguration1, boolean restoreStreams) {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        ProviderFactory providerFactory = new ProviderFactory(startupConfiguration1, providerConfiguration, surefireClassLoader, testsClassLoader, factory);
        SurefireProvider provider = providerFactory.createProvider(insideFork);
        try {
            RunResult runResult = provider.invoke(testSet);
            return runResult;
        }
        catch (TestSetFailedException e) {
            throw new NestedRuntimeException(e);
        }
        catch (ReporterException e) {
            throw new NestedRuntimeException(e);
        }
        finally {
            if (restoreStreams && System.getSecurityManager() == null) {
                System.setOut(orgSystemOut);
                System.setErr(orgSystemErr);
            }
        }
    }

    public SurefireProvider createProvider(boolean isInsideFork) {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.surefireClassLoader);
        StartupConfiguration starterConfiguration = this.startupConfiguration;
        Object o = this.surefireReflector.createBooterConfiguration(this.surefireClassLoader, this.reporterManagerFactory, isInsideFork);
        this.surefireReflector.setTestSuiteDefinitionAware(o, this.providerConfiguration.getTestSuiteDefinition());
        this.surefireReflector.setProviderPropertiesAware(o, this.providerConfiguration.getProviderProperties());
        this.surefireReflector.setReporterConfigurationAware(o, this.providerConfiguration.getReporterConfiguration());
        this.surefireReflector.setTestClassLoaderAware(o, this.surefireClassLoader, this.testsClassLoader);
        this.surefireReflector.setTestArtifactInfoAware(o, this.providerConfiguration.getTestArtifact());
        this.surefireReflector.setRunOrderParameters(o, this.providerConfiguration.getRunOrderParameters());
        this.surefireReflector.setIfDirScannerAware(o, this.providerConfiguration.getDirScannerParams());
        Object provider = this.surefireReflector.instantiateProvider(starterConfiguration.getProviderClassName(), o);
        Thread.currentThread().setContextClassLoader(context);
        return new ProviderProxy(provider, this.testsClassLoader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProviderProxy
    implements SurefireProvider {
        private final Object providerInOtherClassLoader;
        private final ClassLoader testsClassLoader;

        private ProviderProxy(Object providerInOtherClassLoader, ClassLoader testsClassLoader) {
            this.providerInOtherClassLoader = providerInOtherClassLoader;
            this.testsClassLoader = testsClassLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator getSuites() {
            ClassLoader current = this.swapClassLoader(this.testsClassLoader);
            try {
                Iterator iterator = (Iterator)ReflectionUtils.invokeGetter(this.providerInOtherClassLoader, "getSuites");
                return iterator;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
            ClassLoader current = this.swapClassLoader(this.testsClassLoader);
            try {
                Method invoke = ReflectionUtils.getMethod(this.providerInOtherClassLoader.getClass(), "invoke", invokeParamaters);
                Object result = ReflectionUtils.invokeMethodWithArray(this.providerInOtherClassLoader, invoke, new Object[]{forkTestSet});
                RunResult runResult = (RunResult)ProviderFactory.this.surefireReflector.convertIfRunResult(result);
                return runResult;
            }
            finally {
                if (System.getSecurityManager() == null) {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
        }

        private ClassLoader swapClassLoader(ClassLoader newClassLoader) {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(newClassLoader);
            return current;
        }

        public void cancel() {
            Method invoke = ReflectionUtils.getMethod(this.providerInOtherClassLoader.getClass(), "cancel", new Class[0]);
            ReflectionUtils.invokeMethodWithArray(this.providerInOtherClassLoader, invoke, null);
        }
    }
}

